/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.puparser;

import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.jpa.config.PersistenceUnitMetadataHolder;
import org.jboss.as.jpa.config.PersistenceUnitMetadataImpl;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.puparser.Attribute;
import org.jboss.as.jpa.puparser.Element;
import org.jboss.as.jpa.puparser.Version;
import org.jboss.metadata.parser.util.MetaDataElementParser;
import org.jboss.metadata.property.PropertyReplacer;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;

public class PersistenceUnitXmlParser
extends MetaDataElementParser {
    private static final boolean traceEnabled;
    private static final Version DEFAULT_VERSION;

    public static PersistenceUnitMetadataHolder parse(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        reader.require(7, null, null);
        Version version = null;
        while (reader.hasNext() && reader.next() != 1) {
            String dtdLocation;
            if (reader.getEventType() != 11 || (dtdLocation = PersistenceUnitXmlParser.readDTDLocation((XMLStreamReader)reader)) == null) continue;
            version = Version.forLocation(dtdLocation);
        }
        String schemaLocation = PersistenceUnitXmlParser.readSchemaLocation((XMLStreamReader)reader);
        if (schemaLocation != null) {
            version = Version.forLocation(schemaLocation);
        }
        if (version == null || Version.UNKNOWN.equals((Object)version)) {
            String versionString = null;
            int count = reader.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                Attribute attribute;
                String attributeNamespace = reader.getAttributeNamespace(i);
                if (attributeNamespace != null && !attributeNamespace.isEmpty() || (attribute = Attribute.forName(reader.getAttributeLocalName(i))) != Attribute.VERSION) continue;
                versionString = reader.getAttributeValue(i);
            }
            version = Version.forVersion(versionString);
            if (version == Version.UNKNOWN && (version = Version.forVersion(versionString + ".0")) == Version.UNKNOWN) {
                version = DEFAULT_VERSION;
            }
        }
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            String attributeNamespace = reader.getAttributeNamespace(i);
            if (attributeNamespace != null && !attributeNamespace.isEmpty()) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VERSION: {
                    continue block8;
                }
                default: {
                    throw PersistenceUnitXmlParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        ArrayList<PersistenceUnitMetadata> PUs = new ArrayList<PersistenceUnitMetadata>();
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PERSISTENCEUNIT: {
                    PersistenceUnitMetadata pu = PersistenceUnitXmlParser.parsePU(reader, version, propertyReplacer);
                    PUs.add(pu);
                    JpaLogger.ROOT_LOGGER.readingPersistenceXml(pu.getPersistenceUnitName());
                    continue block9;
                }
            }
            throw PersistenceUnitXmlParser.unexpectedElement((XMLStreamReader)reader);
        }
        PersistenceUnitMetadataHolder result = new PersistenceUnitMetadataHolder(PUs);
        if (JpaLogger.ROOT_LOGGER.isTraceEnabled()) {
            JpaLogger.ROOT_LOGGER.trace(result.toString());
        }
        return result;
    }

    private static PersistenceUnitMetadata parsePU(XMLStreamReader reader, Version version, PropertyReplacer propertyReplacer) throws XMLStreamException {
        PersistenceUnitMetadataImpl pu = new PersistenceUnitMetadataImpl();
        ArrayList<String> classes = new ArrayList<String>(1);
        ArrayList<String> jarFiles = new ArrayList<String>(1);
        ArrayList<String> mappingFiles = new ArrayList<String>(1);
        ArrayList<String> qualifiers = new ArrayList<String>(1);
        Properties properties = new Properties();
        pu.setTransactionType(PersistenceUnitTransactionType.JTA);
        pu.setValidationMode(ValidationMode.AUTO);
        pu.setSharedCacheMode(SharedCacheMode.UNSPECIFIED);
        pu.setPersistenceProviderClassName("org.hibernate.jpa.HibernatePersistenceProvider");
        pu.setPersistenceXMLSchemaVersion(version.getVersion());
        int count = reader.getAttributeCount();
        block19: for (int i = 0; i < count; ++i) {
            String attributeNamespace;
            String value = reader.getAttributeValue(i);
            if (traceEnabled) {
                JpaLogger.ROOT_LOGGER.tracef("parse persistence.xml: attribute value(%d) = %s", i, value);
            }
            if ((attributeNamespace = reader.getAttributeNamespace(i)) != null && !attributeNamespace.isEmpty()) continue;
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    pu.setPersistenceUnitName(value);
                    continue block19;
                }
                case TRANSACTIONTYPE: {
                    if (!value.equalsIgnoreCase("RESOURCE_LOCAL")) continue block19;
                    pu.setTransactionType(PersistenceUnitTransactionType.RESOURCE_LOCAL);
                    continue block19;
                }
                default: {
                    throw PersistenceUnitXmlParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                }
            }
        }
        block20: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (traceEnabled) {
                JpaLogger.ROOT_LOGGER.tracef("parse persistence.xml: element=%s", element.getLocalName());
            }
            switch (element) {
                case CLASS: {
                    classes.add(PersistenceUnitXmlParser.getElement(reader, propertyReplacer));
                    continue block20;
                }
                case DESCRIPTION: {
                    String description = PersistenceUnitXmlParser.getElement(reader, propertyReplacer);
                    continue block20;
                }
                case EXCLUDEUNLISTEDCLASSES: {
                    String text = PersistenceUnitXmlParser.getElement(reader, propertyReplacer);
                    if (text == null || text.isEmpty()) {
                        pu.setExcludeUnlistedClasses(true);
                        continue block20;
                    }
                    pu.setExcludeUnlistedClasses(Boolean.valueOf(text));
                    continue block20;
                }
                case JARFILE: {
                    String file = PersistenceUnitXmlParser.getElement(reader, propertyReplacer);
                    jarFiles.add(file);
                    continue block20;
                }
                case JTADATASOURCE: {
                    pu.setJtaDataSourceName(PersistenceUnitXmlParser.getElement(reader, propertyReplacer));
                    continue block20;
                }
                case NONJTADATASOURCE: {
                    pu.setNonJtaDataSourceName(PersistenceUnitXmlParser.getElement(reader, propertyReplacer));
                    continue block20;
                }
                case MAPPINGFILE: {
                    mappingFiles.add(PersistenceUnitXmlParser.getElement(reader, propertyReplacer));
                    continue block20;
                }
                case PROPERTIES: {
                    PersistenceUnitXmlParser.parseProperties(reader, properties, propertyReplacer);
                    continue block20;
                }
                case PROVIDER: {
                    pu.setPersistenceProviderClassName(PersistenceUnitXmlParser.getElement(reader, propertyReplacer));
                    continue block20;
                }
                case SHAREDCACHEMODE: {
                    String cm = PersistenceUnitXmlParser.getElement(reader, propertyReplacer);
                    pu.setSharedCacheMode(SharedCacheMode.valueOf((String)cm));
                    continue block20;
                }
                case VALIDATIONMODE: {
                    String validationMode = PersistenceUnitXmlParser.getElement(reader, propertyReplacer);
                    pu.setValidationMode(ValidationMode.valueOf((String)validationMode));
                    continue block20;
                }
                case SCOPE: {
                    pu.setScopeAnnotationName(PersistenceUnitXmlParser.getElement(reader, propertyReplacer));
                    continue block20;
                }
                case QUALIFIER: {
                    qualifiers.add(PersistenceUnitXmlParser.getElement(reader, propertyReplacer));
                    continue block20;
                }
            }
            throw PersistenceUnitXmlParser.unexpectedElement((XMLStreamReader)reader);
        }
        if (traceEnabled) {
            JpaLogger.ROOT_LOGGER.trace("parse persistence.xml: reached ending persistence-unit tag");
        }
        pu.setManagedClassNames(classes);
        pu.setJarFiles(jarFiles);
        pu.setMappingFiles(mappingFiles);
        pu.setProperties(properties);
        pu.setQualifierAnnotationNames(qualifiers);
        return pu;
    }

    private static void parseProperties(XMLStreamReader reader, Properties properties, PropertyReplacer propertyReplacer) throws XMLStreamException {
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    int count = reader.getAttributeCount();
                    String name = null;
                    String value = null;
                    block8: for (int i = 0; i < count; ++i) {
                        String attributeValue = PersistenceUnitXmlParser.getAttribute(reader, i, propertyReplacer);
                        String attributeNamespace = reader.getAttributeNamespace(i);
                        if (attributeNamespace != null && !attributeNamespace.isEmpty()) continue;
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case NAME: {
                                name = attributeValue;
                                continue block8;
                            }
                            case VALUE: {
                                value = attributeValue;
                                if (name != null && value != null) {
                                    properties.put(name, value);
                                }
                                value = null;
                                name = null;
                                continue block8;
                            }
                            default: {
                                throw PersistenceUnitXmlParser.unexpectedAttribute((XMLStreamReader)reader, (int)i);
                            }
                        }
                    }
                    if (!reader.hasNext() || reader.nextTag() == 2) continue block7;
                    throw PersistenceUnitXmlParser.unexpectedElement((XMLStreamReader)reader);
                }
            }
            throw PersistenceUnitXmlParser.unexpectedElement((XMLStreamReader)reader);
        }
    }

    private static String getElement(XMLStreamReader reader, PropertyReplacer propertyReplacer) throws XMLStreamException {
        return propertyReplacer.replaceProperties(reader.getElementText());
    }

    private static String getAttribute(XMLStreamReader reader, int i, PropertyReplacer propertyReplacer) throws XMLStreamException {
        return propertyReplacer.replaceProperties(reader.getAttributeValue(i));
    }

    static {
        Version defaultVersion;
        traceEnabled = JpaLogger.ROOT_LOGGER.isTraceEnabled();
        try {
            defaultVersion = PersistenceUnitXmlParser.class.getClassLoader().loadClass("jakarta.persistence.SchemaManager") != null ? Version.JPA_3_2 : Version.JPA_3_0;
        }
        catch (Throwable t) {
            defaultVersion = Version.JPA_3_0;
        }
        DEFAULT_VERSION = defaultVersion;
    }
}

