/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.security;

import org.jboss.as.ee.security.JaccService;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.modules.Module;

public abstract class AbstractSecurityDeployer<T> {
    public JaccService<T> deploy(DeploymentUnit deploymentUnit) {
        Object contextId = deploymentUnit.getName();
        if (deploymentUnit.getParent() != null) {
            contextId = deploymentUnit.getParent().getName() + "!" + (String)contextId;
        }
        return this.deploy(deploymentUnit, (String)contextId);
    }

    public JaccService<T> deploy(DeploymentUnit deploymentUnit, String jaccContextId) {
        Object metaData = deploymentUnit.getAttachment(this.getMetaDataType());
        Boolean standalone = Boolean.FALSE;
        if (deploymentUnit.getParent() == null) {
            standalone = Boolean.TRUE;
        }
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        return this.createService(jaccContextId, metaData, standalone, (ClassLoader)module.getClassLoader());
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
    }

    protected abstract JaccService<T> createService(String var1, T var2, Boolean var3, ClassLoader var4);

    protected abstract AttachmentKey<T> getMetaDataType();
}

