/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;

class Reflect {
    Reflect() {
    }

    static Field findField(Class<?> sourceClass, Class<?> fieldType) {
        Class<?> type;
        Field[] fields;
        LinkedList<Field> assignableFields = new LinkedList<Field>();
        for (Field field : fields = sourceClass.getDeclaredFields()) {
            type = field.getType();
            if (Modifier.isStatic(field.getModifiers()) || type != fieldType) continue;
            assignableFields.add(field);
        }
        if (assignableFields.isEmpty()) {
            for (Field field : fields) {
                type = field.getType();
                if (Modifier.isStatic(field.getModifiers()) || type == Object.class || !type.isAssignableFrom(fieldType)) continue;
                assignableFields.add(field);
            }
        }
        if (assignableFields.size() > 1) {
            throw new IllegalStateException(((Object)assignableFields).toString());
        }
        if (!assignableFields.isEmpty()) {
            Field field = (Field)assignableFields.get(0);
            field.setAccessible(true);
            return field;
        }
        Class<?> superClass = sourceClass.getSuperclass();
        if (superClass == null || superClass == Object.class) {
            throw new IllegalArgumentException(fieldType.getName());
        }
        return Reflect.findField(superClass, fieldType);
    }

    static <T> T getValue(Object source, Field field, Class<T> fieldType) {
        try {
            return fieldType.cast(field.get(source));
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

