/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.IllformedLocaleException;
import java.util.Locale;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public enum LocaleMarshaller implements ProtoStreamMarshaller<Locale>
{
    INSTANCE;

    private static final int LANGUAGE_INDEX = 1;
    private static final int REGION_INDEX = 2;
    private static final int VARIANT_INDEX = 3;
    private static final int SCRIPT_INDEX = 4;
    private static final int EXTENSION_INDEX = 5;

    @Override
    public Class<? extends Locale> getJavaClass() {
        return Locale.class;
    }

    @Override
    public Locale readFrom(ProtoStreamReader reader) throws IOException {
        Locale.Builder builder = new Locale.Builder().setLocale(Locale.ROOT);
        String language = Locale.ROOT.getLanguage();
        String region = Locale.ROOT.getCountry();
        String variant = Locale.ROOT.getVariant();
        block9: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    language = reader.readString();
                    continue block9;
                }
                case 2: {
                    region = reader.readString();
                    continue block9;
                }
                case 3: {
                    variant = reader.readString();
                    continue block9;
                }
                case 4: {
                    builder.setScript(reader.readString());
                    continue block9;
                }
                case 5: {
                    String value = reader.readString();
                    builder.setExtension(value.charAt(0), value.substring(1));
                    continue block9;
                }
            }
            reader.skipField(tag);
        }
        try {
            return builder.setLanguage(language).setRegion(region).setVariant(variant).build();
        }
        catch (IllformedLocaleException e) {
            return new Locale(language, region, variant);
        }
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, Locale locale) throws IOException {
        String language = locale.getLanguage();
        if (!Locale.ROOT.getLanguage().equals(language)) {
            writer.writeString(1, language);
        }
        String region = locale.getCountry();
        if (!Locale.ROOT.getCountry().equals(region)) {
            writer.writeString(2, region);
        }
        String variant = locale.getVariant();
        if (!Locale.ROOT.getVariant().equals(variant)) {
            writer.writeString(3, variant);
        }
        String script = locale.getScript();
        if (!Locale.ROOT.getScript().equals(script)) {
            writer.writeString(4, script);
        }
        for (Character key : locale.getExtensionKeys()) {
            String extension = locale.getExtension(key.charValue());
            writer.writeString(5, new StringBuilder(extension.length() + 1).append(key.charValue()).append(extension).toString());
        }
    }
}

