/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.time;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.FieldSetReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.time.LocalDateMarshaller;
import org.wildfly.clustering.marshalling.protostream.time.LocalTimeMarshaller;

public enum LocalDateTimeMarshaller implements ProtoStreamMarshaller<LocalDateTime>
{
    INSTANCE;

    private static final int DATE_INDEX = 1;
    private static final int TIME_INDEX;

    @Override
    public LocalDateTime readFrom(ProtoStreamReader reader) throws IOException {
        FieldSetReader<LocalDate> dateReader = reader.createFieldSetReader(LocalDateMarshaller.INSTANCE, 1);
        FieldSetReader<LocalTime> timeReader = reader.createFieldSetReader(LocalTimeMarshaller.INSTANCE, TIME_INDEX);
        LocalDate date = LocalDateMarshaller.INSTANCE.createInitialValue();
        LocalTime time = LocalTimeMarshaller.INSTANCE.createInitialValue();
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            if (dateReader.contains(index)) {
                date = dateReader.readField(date);
                continue;
            }
            if (timeReader.contains(index)) {
                time = timeReader.readField(time);
                continue;
            }
            reader.skipField(tag);
        }
        return LocalDateTime.of(date, time);
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, LocalDateTime value) throws IOException {
        writer.createFieldSetWriter(LocalDateMarshaller.INSTANCE, 1).writeFields(value.toLocalDate());
        writer.createFieldSetWriter(LocalTimeMarshaller.INSTANCE, TIME_INDEX).writeFields(value.toLocalTime());
    }

    @Override
    public Class<? extends LocalDateTime> getJavaClass() {
        return LocalDateTime.class;
    }

    static {
        TIME_INDEX = LocalDateMarshaller.INSTANCE.nextIndex(1);
    }
}

