/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;
import java.util.function.Supplier;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.FieldReadable;
import org.wildfly.clustering.marshalling.protostream.FieldSetReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.Writable;

public interface FieldSetMarshaller<T, V>
extends FieldReadable<V>,
Writable<T> {
    public V createInitialValue();

    public T build(V var1);

    default public ProtoStreamMarshaller<T> asMarshaller() {
        return this.asMarshaller(this.build(this.createInitialValue()).getClass());
    }

    default public ProtoStreamMarshaller<T> asMarshaller(final Class<T> targetClass) {
        final FieldSetMarshaller marshaller = this;
        return new ProtoStreamMarshaller<T>(this){
            final /* synthetic */ FieldSetMarshaller this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Class<? extends T> getJavaClass() {
                return targetClass;
            }

            @Override
            public T readFrom(ProtoStreamReader reader) throws IOException {
                FieldSetReader valueReader = reader.createFieldSetReader(marshaller, 1);
                Object value = marshaller.createInitialValue();
                while (!reader.isAtEnd()) {
                    int tag = reader.readTag();
                    int index = WireType.getTagFieldNumber((int)tag);
                    if (valueReader.contains(index)) {
                        value = valueReader.readField(value);
                        continue;
                    }
                    reader.skipField(tag);
                }
                return marshaller.build(value);
            }

            @Override
            public void writeTo(ProtoStreamWriter writer, T value) throws IOException {
                writer.createFieldSetWriter(marshaller, 1).writeFields(value);
            }
        };
    }

    public static interface Supplied<T, V extends Supplier<T>>
    extends FieldSetMarshaller<T, V> {
        @Override
        default public T build(V value) {
            return value.get();
        }
    }

    public static interface Entry<T, K, V>
    extends FieldSetMarshaller<T, Map.Entry<K, V>> {
        @Override
        default public Map.Entry<K, V> createInitialValue() {
            return new AbstractMap.SimpleEntry<Object, Object>(null, null);
        }
    }

    public static interface Simple<T>
    extends FieldSetMarshaller<T, T> {
        @Override
        default public T build(T value) {
            return value;
        }
    }
}

