/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.logging.Logger;
import org.jboss.modules.Main;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleLoggerFinder;
import org.jboss.modules.log.ModuleLogger;
import org.jboss.modules.log.NoopModuleLogger;
import org.wildfly.core.embedded.Context;
import org.wildfly.core.embedded.logging.EmbeddedLogger;

class LoggerContext
implements Context {
    private static final String MODULE_ID_LOGGING = "org.jboss.logging";
    private final ModuleLoader moduleLoader;
    private volatile ModuleLogger loggerToRestore;

    LoggerContext(ModuleLoader moduleLoader) {
        this.moduleLoader = moduleLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activate() {
        Module logModule;
        try {
            logModule = this.moduleLoader.loadModule(MODULE_ID_LOGGING);
        }
        catch (ModuleLoadException mle) {
            throw EmbeddedLogger.ROOT_LOGGER.moduleLoaderError(mle, MODULE_ID_LOGGING, this.moduleLoader);
        }
        ModuleClassLoader logModuleClassLoader = logModule.getClassLoader();
        ClassLoader tccl = LoggerContext.getTccl();
        try {
            LoggerContext.setTccl(logModuleClassLoader);
            this.loggerToRestore = Module.getModuleLogger();
            Module.setModuleLogger(new JBossLoggingModuleLogger());
            LoggerContext.configureModuleFinder(tccl);
        }
        finally {
            LoggerContext.setTccl(tccl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore() {
        Module logModule;
        try {
            logModule = this.moduleLoader.loadModule(MODULE_ID_LOGGING);
        }
        catch (ModuleLoadException mle) {
            throw EmbeddedLogger.ROOT_LOGGER.moduleLoaderError(mle, MODULE_ID_LOGGING, this.moduleLoader);
        }
        ModuleClassLoader logModuleClassLoader = logModule.getClassLoader();
        ClassLoader tccl = LoggerContext.getTccl();
        try {
            LoggerContext.setTccl(logModuleClassLoader);
            ModuleLogger loggerToRestore = this.loggerToRestore;
            if (loggerToRestore == null) {
                Module.setModuleLogger(NoopModuleLogger.getInstance());
            } else {
                Module.setModuleLogger(loggerToRestore);
            }
        }
        finally {
            LoggerContext.setTccl(tccl);
        }
    }

    private static void configureModuleFinder(ClassLoader classLoader) {
        Method method;
        if (System.getSecurityManager() == null) {
            try {
                method = ModuleLoggerFinder.class.getDeclaredMethod("activate", ClassLoader.class);
                method.trySetAccessible();
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        } else {
            method = AccessController.doPrivileged(() -> {
                try {
                    Method result = ModuleLoggerFinder.class.getDeclaredMethod("activate", ClassLoader.class);
                    result.trySetAccessible();
                    return result;
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        try {
            method.invoke(null, classLoader);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static ClassLoader getTccl() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static void setTccl(final ClassLoader cl) {
        if (System.getSecurityManager() == null) {
            Thread.currentThread().setContextClassLoader(cl);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Thread.currentThread().setContextClassLoader(cl);
                    return null;
                }
            });
        }
    }

    private static class JBossLoggingModuleLogger
    implements ModuleLogger {
        private final Logger logger = Logger.getLogger("org.jboss.modules");
        private final Logger defineLogger = Logger.getLogger("org.jboss.modules.define");

        private JBossLoggingModuleLogger() {
        }

        @Override
        public void trace(String message) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace(message);
            }
        }

        @Override
        public void trace(String format, Object arg1) {
            if (this.logger.isTraceEnabled()) {
                this.logger.tracef(format, arg1);
            }
        }

        @Override
        public void trace(String format, Object arg1, Object arg2) {
            if (this.logger.isTraceEnabled()) {
                this.logger.tracef(format, arg1, arg2);
            }
        }

        @Override
        public void trace(String format, Object arg1, Object arg2, Object arg3) {
            if (this.logger.isTraceEnabled()) {
                this.logger.tracef(format, arg1, arg2, arg3);
            }
        }

        @Override
        public void trace(String format, Object ... args) {
            if (this.logger.isTraceEnabled()) {
                this.logger.tracef(format, args);
            }
        }

        @Override
        public void trace(Throwable t, String message) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)message, t);
            }
        }

        @Override
        public void trace(Throwable t, String format, Object arg1) {
            if (this.logger.isTraceEnabled()) {
                this.logger.tracef(t, format, arg1);
            }
        }

        @Override
        public void trace(Throwable t, String format, Object arg1, Object arg2) {
            if (this.logger.isTraceEnabled()) {
                this.logger.tracef(t, format, arg1, arg2);
            }
        }

        @Override
        public void trace(Throwable t, String format, Object arg1, Object arg2, Object arg3) {
            if (this.logger.isTraceEnabled()) {
                this.logger.tracef(t, format, arg1, arg2, arg3);
            }
        }

        @Override
        public void trace(Throwable t, String format, Object ... args) {
            if (this.logger.isTraceEnabled()) {
                this.logger.tracef(t, format, args);
            }
        }

        @Override
        public void greeting() {
            if (this.logger.isInfoEnabled()) {
                this.logger.infof("JBoss Modules version %s", (Object)Main.getVersionString());
            }
        }

        @Override
        public void moduleDefined(String name, ModuleLoader moduleLoader) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debugf("Module %s defined by %s", (Object)name, (Object)moduleLoader);
            }
        }

        @Override
        public void classDefineFailed(Throwable throwable, String className, Module module) {
            if (this.defineLogger.isEnabled(Logger.Level.WARN)) {
                this.defineLogger.warnf(throwable, "Failed to define class %s in %s", (Object)className, (Object)module);
            }
        }

        @Override
        public void classDefined(String name, Module module) {
            if (this.defineLogger.isTraceEnabled()) {
                this.defineLogger.tracef("Defined class %s in %s", (Object)name, (Object)module);
            }
        }
    }
}

