/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.user.elytron;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.context.Context;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.session.user.User;
import org.wildfly.clustering.session.user.UserManager;
import org.wildfly.clustering.web.undertow.user.elytron.DistributableSingleSignOn;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.cache.CachedIdentity;
import org.wildfly.security.http.util.sso.SingleSignOn;
import org.wildfly.security.http.util.sso.SingleSignOnManager;

public class DistributableSingleSignOnManager
implements SingleSignOnManager {
    private static final Logger LOGGER = Logger.getLogger(DistributableSingleSignOnManager.class);
    private final UserManager<CachedIdentity, AtomicReference<SecurityIdentity>, String, Map.Entry<String, URI>> manager;

    public DistributableSingleSignOnManager(UserManager<CachedIdentity, AtomicReference<SecurityIdentity>, String, Map.Entry<String, URI>> manager) {
        this.manager = manager;
    }

    public SingleSignOn create(String mechanismName, boolean programmatic, SecurityIdentity identity) {
        DistributableSingleSignOn distributableSingleSignOn;
        block14: {
            String id = (String)this.manager.getIdentifierFactory().get();
            SuspendedBatch suspended = ((Batch)this.manager.getBatchFactory().get()).suspend();
            Context context = suspended.resumeWithContext();
            try {
                User user = this.manager.createUser(id, (Object)new CachedIdentity(mechanismName, programmatic, identity));
                ((AtomicReference)user.getTransientContext()).set(identity);
                distributableSingleSignOn = new DistributableSingleSignOn((User<CachedIdentity, AtomicReference<SecurityIdentity>, String, Map.Entry<String, URI>>)user, suspended);
                if (context == null) break block14;
            }
            catch (Throwable user) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable) {
                            user.addSuppressed(throwable);
                        }
                    }
                    throw user;
                }
                catch (Error | RuntimeException e) {
                    try (Context context2 = suspended.resumeWithContext();){
                        DistributableSingleSignOnManager.rollback((Supplier<Batch>)context2);
                    }
                    throw e;
                }
            }
            context.close();
        }
        return distributableSingleSignOn;
    }

    public SingleSignOn find(String id) {
        DistributableSingleSignOn distributableSingleSignOn;
        block14: {
            SuspendedBatch suspended = ((Batch)this.manager.getBatchFactory().get()).suspend();
            Context context = suspended.resumeWithContext();
            try {
                User user = this.manager.findUser(id);
                DistributableSingleSignOn distributableSingleSignOn2 = distributableSingleSignOn = user != null ? new DistributableSingleSignOn((User<CachedIdentity, AtomicReference<SecurityIdentity>, String, Map.Entry<String, URI>>)user, suspended) : DistributableSingleSignOnManager.close((Supplier<Batch>)context);
                if (context == null) break block14;
            }
            catch (Throwable user) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable) {
                            user.addSuppressed(throwable);
                        }
                    }
                    throw user;
                }
                catch (Error | RuntimeException e) {
                    try (Context context2 = suspended.resumeWithContext();){
                        DistributableSingleSignOnManager.rollback((Supplier<Batch>)context2);
                    }
                    throw e;
                }
            }
            context.close();
        }
        return distributableSingleSignOn;
    }

    private static SingleSignOn close(Supplier<Batch> batchProvider) {
        DistributableSingleSignOnManager.close(batchProvider, (Consumer<Batch>)Consumer.empty());
        return null;
    }

    private static void rollback(Supplier<Batch> batchProvider) {
        DistributableSingleSignOnManager.close(batchProvider, (Consumer<Batch>)((Consumer)Batch::discard));
    }

    private static void close(Supplier<Batch> batchProvider, Consumer<Batch> batchTask) {
        try (Batch batch = batchProvider.get();){
            batchTask.accept((Object)batch);
        }
        catch (Error | RuntimeException e) {
            LOGGER.error((Object)e.getLocalizedMessage(), e);
        }
    }
}

