/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.clustering.server.registry;

import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.infinispan.Cache;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.infinispan.CacheContainerGroup;
import org.wildfly.clustering.server.infinispan.CacheContainerGroupMember;
import org.wildfly.clustering.server.infinispan.registry.CacheRegistry;
import org.wildfly.clustering.server.registry.Registry;
import org.wildfly.clustering.server.registry.RegistryFactory;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.extension.clustering.server.registry.AbstractRegistryFactoryServiceInstallerFactory;
import org.wildfly.service.Installer;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class CacheRegistryFactoryServiceInstallerFactory<K, V>
extends AbstractRegistryFactoryServiceInstallerFactory<K, V> {
    public ServiceInstaller apply(BinaryServiceConfiguration configuration) {
        final ServiceDependency group = configuration.getServiceDependency(ClusteringServiceDescriptor.GROUP).map(CacheContainerGroup.class::cast);
        final ServiceDependency cache = configuration.getServiceDependency(InfinispanServiceDescriptor.CACHE);
        RegistryFactory factory = RegistryFactory.singleton((BiFunction)new BiFunction<Map.Entry<Object, Object>, Runnable, Registry<CacheContainerGroupMember, Object, Object>>(){

            @Override
            public Registry<CacheContainerGroupMember, Object, Object> apply(final Map.Entry<Object, Object> entry, final Runnable closeTask) {
                return new CacheRegistry((CacheRegistry.Configuration)new CacheRegistry.Configuration<Object, Object>(){

                    public <KK, VV> Cache<KK, VV> getCache() {
                        return (Cache)cache.get();
                    }

                    public Runnable getCloseTask() {
                        return closeTask;
                    }

                    public Map.Entry<Object, Object> getEntry() {
                        return entry;
                    }

                    public CacheContainerGroup getGroup() {
                        return (CacheContainerGroup)group.get();
                    }
                });
            }
        });
        return (ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Object)factory).blocking()).provides(configuration.resolveServiceName(this.getServiceDescriptor()))).startWhen(Installer.StartWhen.REQUIRED)).requires(List.of(group, cache))).build();
    }
}

