/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Supplier;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionMetaData;

public class DetachedSessionMetaData<C, B extends Batch>
implements SessionMetaData {
    private final Supplier<B> batchFactory;
    private final Supplier<Session<C>> sessionFactory;

    public DetachedSessionMetaData(Supplier<B> batchFactory, Supplier<Session<C>> sessionFactory) {
        this.batchFactory = batchFactory;
        this.sessionFactory = sessionFactory;
    }

    public boolean isNew() {
        return false;
    }

    public boolean isExpired() {
        try (Batch batch = (Batch)this.batchFactory.get();){
            boolean bl;
            block12: {
                Session<C> session = this.sessionFactory.get();
                try {
                    bl = session.getMetaData().isExpired();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return bl;
        }
    }

    public Instant getCreationTime() {
        try (Batch batch = (Batch)this.batchFactory.get();){
            Instant instant;
            block12: {
                Session<C> session = this.sessionFactory.get();
                try {
                    instant = session.getMetaData().getCreationTime();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return instant;
        }
    }

    public Instant getLastAccessStartTime() {
        try (Batch batch = (Batch)this.batchFactory.get();){
            Instant instant;
            block12: {
                Session<C> session = this.sessionFactory.get();
                try {
                    instant = session.getMetaData().getLastAccessStartTime();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return instant;
        }
    }

    public Instant getLastAccessEndTime() {
        try (Batch batch = (Batch)this.batchFactory.get();){
            Instant instant;
            block12: {
                Session<C> session = this.sessionFactory.get();
                try {
                    instant = session.getMetaData().getLastAccessEndTime();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return instant;
        }
    }

    public Duration getTimeout() {
        try (Batch batch = (Batch)this.batchFactory.get();){
            Duration duration;
            block12: {
                Session<C> session = this.sessionFactory.get();
                try {
                    duration = session.getMetaData().getTimeout();
                    if (session == null) break block12;
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        try {
                            session.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                session.close();
            }
            return duration;
        }
    }

    public void setTimeout(Duration duration) {
        try (Batch batch = (Batch)this.batchFactory.get();
             Session<C> session = this.sessionFactory.get();){
            session.getMetaData().setTimeout(duration);
        }
    }

    public void setLastAccess(Instant startTime, Instant endTime) {
        throw new IllegalStateException();
    }
}

