/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.attributes.coarse;

import java.io.NotSerializableException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.wildfly.clustering.session.cache.attributes.AbstractSessionAttributes;
import org.wildfly.clustering.session.cache.attributes.coarse.SessionActivationNotifier;

public class CoarseSessionAttributes
extends AbstractSessionAttributes {
    private final Map<String, Object> attributes;
    private final Runnable mutator;
    private final Predicate<Object> marshallable;
    private final Predicate<Object> immutable;
    private final SessionActivationNotifier notifier;
    private final AtomicBoolean dirty = new AtomicBoolean(false);

    public CoarseSessionAttributes(Map<String, Object> attributes, Runnable mutator, Predicate<Object> marshallable, Predicate<Object> immutable, SessionActivationNotifier notifier) {
        super(attributes);
        this.attributes = attributes;
        this.mutator = mutator;
        this.marshallable = marshallable;
        this.immutable = immutable;
        this.notifier = notifier;
        if (this.notifier != null) {
            this.notifier.postActivate();
        }
    }

    @Override
    public Object remove(Object key) {
        Object value = this.attributes.remove(key);
        if (value != null) {
            this.dirty.set(true);
        }
        return value;
    }

    @Override
    public Object put(String key, Object value) {
        if (value == null) {
            return this.remove(key);
        }
        if (!this.marshallable.test(value)) {
            throw new IllegalArgumentException(new NotSerializableException(value.getClass().getName()));
        }
        Object old = this.attributes.put(key, value);
        this.dirty.set(true);
        return old;
    }

    @Override
    public Object get(Object key) {
        Object value = this.attributes.get(key);
        if (value != null && !this.dirty.get() && !this.immutable.test(value)) {
            this.dirty.set(true);
        }
        return value;
    }

    @Override
    public void close() {
        if (this.notifier != null) {
            this.notifier.prePassivate();
        }
        if (this.dirty.compareAndSet(true, false)) {
            this.mutator.run();
        }
    }
}

