/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import javax.management.ObjectName;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederation;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConsumer;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConsumerControlType;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationLocalPolicyControlType;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationLocalPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationProducerControlType;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationRemotePolicyControlType;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationRemotePolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationSenderController;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationSource;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationSourceControlType;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationTarget;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationTargetControlType;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumerInfo;
import org.apache.activemq.artemis.utils.CompositeAddress;

public abstract class AMQPFederationManagementSupport {
    public static final String FEDERATION_SOURCE_RESOURCE_TEMPLATE = "brokerconnection.%s.federation.%s";
    public static final String FEDERATION_SOURCE_POLICY_RESOURCE_TEMPLATE = "brokerconnection.%s.federation.%s.policy.%s";
    public static final String FEDERATION_SOURCE_CONSUMER_RESOURCE_TEMPLATE = "brokerconnection.%s.federation.%s.policy.%s.consumer.%s";
    public static final String FEDERATION_SOURCE_PRODUCER_RESOURCE_TEMPLATE = "brokerconnection.%s.federation.%s.policy.%s.producer.%s";
    public static final String FEDERATION_TARGET_RESOURCE_TEMPLATE = "node.%s.brokerconnection.%s.federation.%s";
    public static final String FEDERATION_TARGET_POLICY_RESOURCE_TEMPLATE = "node.%s.brokerconnection.%s.federation.%s.policy.%s";
    public static final String FEDERATION_TARGET_CONSUMER_RESOURCE_TEMPLATE = "node.%s.brokerconnection.%s.federation.%s.policy.%s.consumer.%s";
    public static final String FEDERATION_TARGET_PRODUCER_RESOURCE_TEMPLATE = "node.%s.brokerconnection.%s.federation.%s.policy.%s.producer.%s";
    public static final String FEDERATION_NAME_TEMPLATE = "serviceCatagory=federations,federationName=%s";
    public static final String FEDERATION_POLICY_NAME_TEMPLATE = "serviceCatagory=federations,federationName=%s,policyType=%s,policyName=%s";
    public static final String FEDERATION_QUEUE_CONSUMER_NAME_TEMPLATE = "serviceCatagory=federations,federationName=%s,policyType=%s,policyName=%s,linkType=consumers,fqqn=%s";
    public static final String FEDERATION_ADDRESS_CONSUMER_NAME_TEMPLATE = "serviceCatagory=federations,federationName=%s,policyType=%s,policyName=%s,linkType=consumers,address=%s";
    public static final String FEDERATION_QUEUE_PRODUCER_NAME_TEMPLATE = "serviceCatagory=federations,federationName=%s,policyType=%s,policyName=%s,linkType=producers,fqqn=%s";
    public static final String FEDERATION_ADDRESS_PRODUCER_NAME_TEMPLATE = "serviceCatagory=federations,federationName=%s,policyType=%s,policyName=%s,linkType=producers,address=%s";

    public static void registerFederationSource(AMQPFederationSource federation) throws Exception {
        String federationName = federation.getName();
        String brokerConnectionName = federation.getBrokerConnection().getName();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        AMQPFederationSourceControlType control = new AMQPFederationSourceControlType(server, federation);
        management.registerInJMX(AMQPFederationManagementSupport.getFederationSourceObjectName(management, brokerConnectionName, federationName), (Object)control);
        management.registerInRegistry(AMQPFederationManagementSupport.getFederationSourceResourceName(brokerConnectionName, federationName), (Object)control);
    }

    public static void unregisterFederationSource(AMQPFederationSource federation) throws Exception {
        String federationName = federation.getName();
        String brokerConnectionName = federation.getBrokerConnection().getName();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        management.unregisterFromJMX(AMQPFederationManagementSupport.getFederationSourceObjectName(management, brokerConnectionName, federationName));
        management.unregisterFromRegistry(AMQPFederationManagementSupport.getFederationSourceResourceName(brokerConnectionName, federationName));
    }

    public static String getFederationSourceResourceName(String brokerConnectionName, String federationName) {
        return String.format(FEDERATION_SOURCE_RESOURCE_TEMPLATE, brokerConnectionName, federationName);
    }

    public static ObjectName getFederationSourceObjectName(ManagementService management, String brokerConnection, String federationName) throws Exception {
        return ObjectName.getInstance(String.format("%s,serviceCatagory=federations,federationName=%s", management.getObjectNameBuilder().getBrokerConnectionBaseObjectNameString(brokerConnection), ObjectName.quote(federationName)));
    }

    public static void registerFederationTarget(String remoteNodeId, String brokerConnectionName, AMQPFederationTarget federation) throws Exception {
        String federationName = federation.getName();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        AMQPFederationTargetControlType control = new AMQPFederationTargetControlType(server, federation);
        management.registerInJMX(AMQPFederationManagementSupport.getFederationTargetObjectName(management, remoteNodeId, brokerConnectionName, federationName), (Object)control);
        management.registerInRegistry(AMQPFederationManagementSupport.getFederationTargetResourceName(remoteNodeId, brokerConnectionName, federationName), (Object)control);
    }

    public static void unregisterFederationTarget(String remoteNodeId, String brokerConnectionName, AMQPFederationTarget federation) throws Exception {
        String federationName = federation.getName();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        management.unregisterFromJMX(AMQPFederationManagementSupport.getFederationTargetObjectName(management, remoteNodeId, brokerConnectionName, federationName));
        management.unregisterFromRegistry(AMQPFederationManagementSupport.getFederationTargetResourceName(remoteNodeId, brokerConnectionName, federationName));
    }

    public static String getFederationTargetResourceName(String remoteNodeId, String brokerConnectionName, String federationName) {
        return String.format(FEDERATION_TARGET_RESOURCE_TEMPLATE, remoteNodeId, brokerConnectionName, federationName);
    }

    public static ObjectName getFederationTargetObjectName(ManagementService management, String remoteNodeId, String brokerConnection, String federationName) throws Exception {
        return ObjectName.getInstance(String.format("%s,serviceCatagory=federations,federationName=%s", management.getObjectNameBuilder().getRemoteBrokerConnectionBaseObjectNameString(remoteNodeId, brokerConnection), ObjectName.quote(federationName)));
    }

    public static void registerLocalPolicyOnSource(String brokerConnectionName, AMQPFederationLocalPolicyManager manager) throws Exception {
        AMQPFederation federation = manager.getFederation();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        AMQPFederationLocalPolicyControlType control = new AMQPFederationLocalPolicyControlType(manager);
        String federationName = federation.getName();
        String policyName = manager.getPolicyName();
        management.registerInJMX(AMQPFederationManagementSupport.getFederationSourcePolicyObjectName(management, brokerConnectionName, federationName, manager.getPolicyType().toString(), policyName), (Object)control);
        management.registerInRegistry(AMQPFederationManagementSupport.getFederationSourcePolicyResourceName(brokerConnectionName, federationName, policyName), (Object)control);
    }

    public static void unregisterLocalPolicyOnSource(String brokerConnectionName, AMQPFederationLocalPolicyManager manager) throws Exception {
        AMQPFederation federation = manager.getFederation();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        String federationName = federation.getName();
        String policyName = manager.getPolicyName();
        management.unregisterFromJMX(AMQPFederationManagementSupport.getFederationSourcePolicyObjectName(management, brokerConnectionName, federationName, manager.getPolicyType().toString(), policyName));
        management.unregisterFromRegistry(AMQPFederationManagementSupport.getFederationSourcePolicyResourceName(brokerConnectionName, federationName, policyName));
    }

    public static void registerRemotePolicyOnSource(String brokerConnectionName, AMQPFederationRemotePolicyManager manager) throws Exception {
        AMQPFederation federation = manager.getFederation();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        AMQPFederationRemotePolicyControlType control = new AMQPFederationRemotePolicyControlType(server, manager);
        String federationName = federation.getName();
        String policyName = manager.getPolicyName();
        management.registerInJMX(AMQPFederationManagementSupport.getFederationSourcePolicyObjectName(management, brokerConnectionName, federationName, manager.getPolicyType().toString(), policyName), (Object)control);
        management.registerInRegistry(AMQPFederationManagementSupport.getFederationSourcePolicyResourceName(brokerConnectionName, federationName, policyName), (Object)control);
    }

    public static void unregisterRemotePolicyOnSource(String brokerConnectionName, AMQPFederationRemotePolicyManager manager) throws Exception {
        AMQPFederation federation = manager.getFederation();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        String federationName = federation.getName();
        String policyName = manager.getPolicyName();
        management.unregisterFromJMX(AMQPFederationManagementSupport.getFederationSourcePolicyObjectName(management, brokerConnectionName, federationName, manager.getPolicyType().toString(), policyName));
        management.unregisterFromRegistry(AMQPFederationManagementSupport.getFederationSourcePolicyResourceName(brokerConnectionName, federationName, policyName));
    }

    public static String getFederationSourcePolicyResourceName(String brokerConnectionName, String federationName, String policyName) {
        return String.format(FEDERATION_SOURCE_POLICY_RESOURCE_TEMPLATE, brokerConnectionName, federationName, policyName);
    }

    public static ObjectName getFederationSourcePolicyObjectName(ManagementService management, String brokerConnection, String federationName, String policyType, String policyName) throws Exception {
        return ObjectName.getInstance(String.format("%s,serviceCatagory=federations,federationName=%s,policyType=%s,policyName=%s", management.getObjectNameBuilder().getBrokerConnectionBaseObjectNameString(brokerConnection), ObjectName.quote(federationName), ObjectName.quote(policyType), ObjectName.quote(policyName)));
    }

    public static void registerLocalPolicyOnTarget(String remoteNodeId, String brokerConnectionName, AMQPFederationLocalPolicyManager manager) throws Exception {
        AMQPFederation federation = manager.getFederation();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        AMQPFederationLocalPolicyControlType control = new AMQPFederationLocalPolicyControlType(manager);
        String federationName = federation.getName();
        String policyName = manager.getPolicyName();
        management.registerInJMX(AMQPFederationManagementSupport.getFederationTargetPolicyObjectName(management, remoteNodeId, brokerConnectionName, federationName, manager.getPolicyType().toString(), policyName), (Object)control);
        management.registerInRegistry(AMQPFederationManagementSupport.getFederationTargetPolicyResourceName(remoteNodeId, brokerConnectionName, federationName, policyName), (Object)control);
    }

    public static void unregisterLocalPolicyOnTarget(String remoteNodeId, String brokerConnectionName, AMQPFederationLocalPolicyManager manager) throws Exception {
        AMQPFederation federation = manager.getFederation();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        String federationName = federation.getName();
        String policyName = manager.getPolicyName();
        management.unregisterFromJMX(AMQPFederationManagementSupport.getFederationTargetPolicyObjectName(management, remoteNodeId, brokerConnectionName, federationName, manager.getPolicyType().toString(), policyName));
        management.unregisterFromRegistry(AMQPFederationManagementSupport.getFederationTargetPolicyResourceName(remoteNodeId, brokerConnectionName, federationName, policyName));
    }

    public static void registerRemotePolicyOnTarget(String remoteNodeId, String brokerConnectionName, AMQPFederationRemotePolicyManager manager) throws Exception {
        AMQPFederation federation = manager.getFederation();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        AMQPFederationRemotePolicyControlType control = new AMQPFederationRemotePolicyControlType(server, manager);
        String federationName = federation.getName();
        String policyName = manager.getPolicyName();
        management.registerInJMX(AMQPFederationManagementSupport.getFederationTargetPolicyObjectName(management, remoteNodeId, brokerConnectionName, federationName, manager.getPolicyType().toString(), policyName), (Object)control);
        management.registerInRegistry(AMQPFederationManagementSupport.getFederationTargetPolicyResourceName(remoteNodeId, brokerConnectionName, federationName, policyName), (Object)control);
    }

    public static void unregisterRemotePolicyOnTarget(String remoteNodeId, String brokerConnectionName, AMQPFederationRemotePolicyManager manager) throws Exception {
        AMQPFederation federation = manager.getFederation();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        String federationName = federation.getName();
        String policyName = manager.getPolicyName();
        management.unregisterFromJMX(AMQPFederationManagementSupport.getFederationTargetPolicyObjectName(management, remoteNodeId, brokerConnectionName, federationName, manager.getPolicyType().toString(), policyName));
        management.unregisterFromRegistry(AMQPFederationManagementSupport.getFederationTargetPolicyResourceName(remoteNodeId, brokerConnectionName, federationName, policyName));
    }

    public static String getFederationTargetPolicyResourceName(String remoteNodeId, String brokerConnectionName, String federationName, String policyName) {
        return String.format(FEDERATION_TARGET_POLICY_RESOURCE_TEMPLATE, remoteNodeId, brokerConnectionName, federationName, policyName);
    }

    public static ObjectName getFederationTargetPolicyObjectName(ManagementService management, String remoteNodeId, String brokerConnection, String federationName, String policyType, String policyName) throws Exception {
        return ObjectName.getInstance(String.format("%s,serviceCatagory=federations,federationName=%s,policyType=%s,policyName=%s", management.getObjectNameBuilder().getRemoteBrokerConnectionBaseObjectNameString(remoteNodeId, brokerConnection), ObjectName.quote(federationName), ObjectName.quote(policyType), ObjectName.quote(policyName)));
    }

    public static void registerFederationSourceConsumer(String brokerConnectionName, AMQPFederationConsumer consumer) throws Exception {
        AMQPFederationLocalPolicyManager manager = consumer.getPolicyManager();
        AMQPFederation federation = manager.getFederation();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        AMQPFederationConsumerControlType control = new AMQPFederationConsumerControlType(consumer);
        String federationName = federation.getName();
        String policyName = manager.getPolicyName();
        if (consumer.getRole() == FederationConsumerInfo.Role.ADDRESS_CONSUMER) {
            management.registerInJMX(AMQPFederationManagementSupport.getFederationSourceAddressConsumerObjectName(management, brokerConnectionName, federationName, manager.getPolicyType().toString(), policyName, consumer.getConsumerInfo().getAddress()), (Object)control);
            management.registerInRegistry(AMQPFederationManagementSupport.getFederationSourceAddressConsumerResourceName(brokerConnectionName, federationName, policyName, consumer.getConsumerInfo().getAddress()), (Object)control);
        } else {
            management.registerInJMX(AMQPFederationManagementSupport.getFederationSourceQueueConsumerObjectName(management, brokerConnectionName, federationName, manager.getPolicyType().toString(), policyName, consumer.getConsumerInfo().getFqqn()), (Object)control);
            management.registerInRegistry(AMQPFederationManagementSupport.getFederationSourceQueueConsumerResourceName(brokerConnectionName, federationName, policyName, consumer.getConsumerInfo().getFqqn()), (Object)control);
        }
    }

    public static void unregisterFederationSourceConsumer(String brokerConnectionName, AMQPFederationConsumer consumer) throws Exception {
        AMQPFederationLocalPolicyManager manager = consumer.getPolicyManager();
        AMQPFederation federation = manager.getFederation();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        String federationName = federation.getName();
        String policyName = manager.getPolicyName();
        if (consumer.getRole() == FederationConsumerInfo.Role.ADDRESS_CONSUMER) {
            management.unregisterFromJMX(AMQPFederationManagementSupport.getFederationSourceAddressConsumerObjectName(management, brokerConnectionName, federationName, manager.getPolicyType().toString(), policyName, consumer.getConsumerInfo().getAddress()));
            management.unregisterFromRegistry(AMQPFederationManagementSupport.getFederationSourceAddressConsumerResourceName(brokerConnectionName, federationName, policyName, consumer.getConsumerInfo().getAddress()));
        } else {
            management.unregisterFromJMX(AMQPFederationManagementSupport.getFederationSourceQueueConsumerObjectName(management, brokerConnectionName, federationName, manager.getPolicyType().toString(), policyName, consumer.getConsumerInfo().getFqqn()));
            management.unregisterFromRegistry(AMQPFederationManagementSupport.getFederationSourceQueueConsumerResourceName(brokerConnectionName, federationName, policyName, consumer.getConsumerInfo().getFqqn()));
        }
    }

    public static void registerFederationSourceProducer(String brokerConnectionName, AMQPFederationSenderController sender) throws Exception {
        AMQPFederationRemotePolicyManager manager = sender.getPolicyManager();
        AMQPFederation federation = manager.getFederation();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        AMQPFederationProducerControlType control = new AMQPFederationProducerControlType(sender);
        String federationName = federation.getName();
        String policyName = manager.getPolicyName();
        if (sender.getRole() == AMQPFederationSenderController.Role.ADDRESS_PRODUCER) {
            String address = control.getAddress();
            management.registerInJMX(AMQPFederationManagementSupport.getFederationSourceAddressProducerObjectName(management, brokerConnectionName, federationName, manager.getPolicyType().toString(), policyName, address), (Object)control);
            management.registerInRegistry(AMQPFederationManagementSupport.getFederationSourceAddressProducerResourceName(brokerConnectionName, federationName, policyName, address), (Object)control);
        } else {
            String fqqn = control.getFqqn();
            management.registerInJMX(AMQPFederationManagementSupport.getFederationSourceQueueProducerObjectName(management, brokerConnectionName, federationName, manager.getPolicyType().toString(), policyName, fqqn), (Object)control);
            management.registerInRegistry(AMQPFederationManagementSupport.getFederationSourceQueueProducerResourceName(brokerConnectionName, federationName, policyName, fqqn), (Object)control);
        }
    }

    public static void unregisterFederationSourceProducer(String brokerConnectionName, AMQPFederationSenderController sender) throws Exception {
        AMQPFederationRemotePolicyManager manager = sender.getPolicyManager();
        AMQPFederation federation = manager.getFederation();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        String federationName = federation.getName();
        String policyName = manager.getPolicyName();
        if (sender.getRole() == AMQPFederationSenderController.Role.ADDRESS_PRODUCER) {
            String address = sender.getServerConsumer().getQueueAddress().toString();
            management.unregisterFromJMX(AMQPFederationManagementSupport.getFederationSourceAddressProducerObjectName(management, brokerConnectionName, federationName, manager.getPolicyType().toString(), policyName, address));
            management.unregisterFromRegistry(AMQPFederationManagementSupport.getFederationSourceAddressProducerResourceName(brokerConnectionName, federationName, policyName, address));
        } else {
            String fqqn = CompositeAddress.toFullyQualified((String)sender.getServerConsumer().getQueueAddress().toString(), (String)sender.getServerConsumer().getQueueName().toString());
            management.unregisterFromJMX(AMQPFederationManagementSupport.getFederationSourceQueueProducerObjectName(management, brokerConnectionName, federationName, manager.getPolicyType().toString(), policyName, fqqn));
            management.unregisterFromRegistry(AMQPFederationManagementSupport.getFederationSourceQueueProducerResourceName(brokerConnectionName, federationName, policyName, fqqn));
        }
    }

    public static String getFederationSourceAddressConsumerResourceName(String brokerConnectionName, String federationName, String policyName, String address) {
        return String.format(FEDERATION_SOURCE_CONSUMER_RESOURCE_TEMPLATE, brokerConnectionName, federationName, policyName, address);
    }

    public static String getFederationSourceQueueConsumerResourceName(String brokerConnectionName, String federationName, String policyName, String fqqn) {
        return String.format(FEDERATION_SOURCE_CONSUMER_RESOURCE_TEMPLATE, brokerConnectionName, federationName, policyName, fqqn);
    }

    public static String getFederationSourceAddressProducerResourceName(String brokerConnectionName, String federationName, String policyName, String address) {
        return String.format(FEDERATION_SOURCE_PRODUCER_RESOURCE_TEMPLATE, brokerConnectionName, federationName, policyName, address);
    }

    public static String getFederationSourceQueueProducerResourceName(String brokerConnectionName, String federationName, String policyName, String fqqn) {
        return String.format(FEDERATION_SOURCE_PRODUCER_RESOURCE_TEMPLATE, brokerConnectionName, federationName, policyName, fqqn);
    }

    public static ObjectName getFederationSourceAddressConsumerObjectName(ManagementService management, String brokerConnection, String federationName, String policyType, String policyName, String address) throws Exception {
        return ObjectName.getInstance(String.format("%s,serviceCatagory=federations,federationName=%s,policyType=%s,policyName=%s,linkType=consumers,address=%s", management.getObjectNameBuilder().getBrokerConnectionBaseObjectNameString(brokerConnection), ObjectName.quote(federationName), ObjectName.quote(policyType), ObjectName.quote(policyName), ObjectName.quote(address)));
    }

    public static ObjectName getFederationSourceAddressProducerObjectName(ManagementService management, String brokerConnection, String federationName, String policyType, String policyName, String address) throws Exception {
        return ObjectName.getInstance(String.format("%s,serviceCatagory=federations,federationName=%s,policyType=%s,policyName=%s,linkType=producers,address=%s", management.getObjectNameBuilder().getBrokerConnectionBaseObjectNameString(brokerConnection), ObjectName.quote(federationName), ObjectName.quote(policyType), ObjectName.quote(policyName), ObjectName.quote(address)));
    }

    public static ObjectName getFederationSourceQueueConsumerObjectName(ManagementService management, String brokerConnection, String federationName, String policyType, String policyName, String fqqn) throws Exception {
        return ObjectName.getInstance(String.format("%s,serviceCatagory=federations,federationName=%s,policyType=%s,policyName=%s,linkType=consumers,fqqn=%s", management.getObjectNameBuilder().getBrokerConnectionBaseObjectNameString(brokerConnection), ObjectName.quote(federationName), ObjectName.quote(policyType), ObjectName.quote(policyName), ObjectName.quote(fqqn)));
    }

    public static ObjectName getFederationSourceQueueProducerObjectName(ManagementService management, String brokerConnection, String federationName, String policyType, String policyName, String fqqn) throws Exception {
        return ObjectName.getInstance(String.format("%s,serviceCatagory=federations,federationName=%s,policyType=%s,policyName=%s,linkType=producers,fqqn=%s", management.getObjectNameBuilder().getBrokerConnectionBaseObjectNameString(brokerConnection), ObjectName.quote(federationName), ObjectName.quote(policyType), ObjectName.quote(policyName), ObjectName.quote(fqqn)));
    }

    public static void registerFederationTargetConsumer(String remoteNodeId, String brokerConnectionName, AMQPFederationConsumer consumer) throws Exception {
        AMQPFederationLocalPolicyManager manager = consumer.getPolicyManager();
        AMQPFederation federation = manager.getFederation();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        AMQPFederationConsumerControlType control = new AMQPFederationConsumerControlType(consumer);
        String federationName = federation.getName();
        String policyName = manager.getPolicyName();
        if (consumer.getRole() == FederationConsumerInfo.Role.ADDRESS_CONSUMER) {
            management.registerInJMX(AMQPFederationManagementSupport.getFederationTargetAddressConsumerObjectName(management, remoteNodeId, brokerConnectionName, federationName, manager.getPolicyType().toString(), policyName, consumer.getConsumerInfo().getAddress()), (Object)control);
            management.registerInRegistry(AMQPFederationManagementSupport.getFederationTargetAddressConsumerResourceName(remoteNodeId, brokerConnectionName, federationName, policyName, consumer.getConsumerInfo().getAddress()), (Object)control);
        } else {
            management.registerInJMX(AMQPFederationManagementSupport.getFederationTargetQueueConsumerObjectName(management, remoteNodeId, brokerConnectionName, federationName, manager.getPolicyType().toString(), policyName, consumer.getConsumerInfo().getFqqn()), (Object)control);
            management.registerInRegistry(AMQPFederationManagementSupport.getFederationTargetQueueConsumerResourceName(remoteNodeId, brokerConnectionName, federationName, policyName, consumer.getConsumerInfo().getFqqn()), (Object)control);
        }
    }

    public static void unregisterFederationTargetConsumer(String remoteNodeId, String brokerConnectionName, AMQPFederationConsumer consumer) throws Exception {
        AMQPFederationLocalPolicyManager manager = consumer.getPolicyManager();
        AMQPFederation federation = manager.getFederation();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        String federationName = federation.getName();
        String policyName = manager.getPolicyName();
        if (consumer.getRole() == FederationConsumerInfo.Role.ADDRESS_CONSUMER) {
            management.unregisterFromJMX(AMQPFederationManagementSupport.getFederationTargetAddressConsumerObjectName(management, remoteNodeId, brokerConnectionName, federationName, manager.getPolicyType().toString(), policyName, consumer.getConsumerInfo().getAddress()));
            management.unregisterFromRegistry(AMQPFederationManagementSupport.getFederationTargetAddressConsumerResourceName(remoteNodeId, brokerConnectionName, federationName, policyName, consumer.getConsumerInfo().getAddress()));
        } else {
            management.unregisterFromJMX(AMQPFederationManagementSupport.getFederationTargetQueueConsumerObjectName(management, remoteNodeId, brokerConnectionName, federationName, manager.getPolicyType().toString(), policyName, consumer.getConsumerInfo().getFqqn()));
            management.unregisterFromRegistry(AMQPFederationManagementSupport.getFederationTargetQueueConsumerResourceName(remoteNodeId, brokerConnectionName, federationName, policyName, consumer.getConsumerInfo().getFqqn()));
        }
    }

    public static void registerFederationTargetProducer(String remoteNodeId, String brokerConnectionName, AMQPFederationSenderController sender) throws Exception {
        AMQPFederationRemotePolicyManager manager = sender.getPolicyManager();
        AMQPFederation federation = manager.getFederation();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        AMQPFederationProducerControlType control = new AMQPFederationProducerControlType(sender);
        String federationName = federation.getName();
        String policyName = manager.getPolicyName();
        if (sender.getRole() == AMQPFederationSenderController.Role.ADDRESS_PRODUCER) {
            String address = control.getAddress();
            management.registerInJMX(AMQPFederationManagementSupport.getFederationTargetAddressProducerObjectName(management, remoteNodeId, brokerConnectionName, federationName, manager.getPolicyType().toString(), policyName, address), (Object)control);
            management.registerInRegistry(AMQPFederationManagementSupport.getFederationTargetAddressProducerResourceName(remoteNodeId, brokerConnectionName, federationName, policyName, address), (Object)control);
        } else {
            String fqqn = control.getFqqn();
            management.registerInJMX(AMQPFederationManagementSupport.getFederationTargetQueueProducerObjectName(management, remoteNodeId, brokerConnectionName, federationName, manager.getPolicyType().toString(), policyName, fqqn), (Object)control);
            management.registerInRegistry(AMQPFederationManagementSupport.getFederationTargetQueueProducerResourceName(remoteNodeId, brokerConnectionName, federationName, policyName, fqqn), (Object)control);
        }
    }

    public static void unregisterFederationTargetProducer(String remoteNodeId, String brokerConnectionName, AMQPFederationSenderController sender) throws Exception {
        AMQPFederationRemotePolicyManager manager = sender.getPolicyManager();
        AMQPFederation federation = manager.getFederation();
        ActiveMQServer server = federation.getServer();
        ManagementService management = server.getManagementService();
        String federationName = federation.getName();
        String policyName = manager.getPolicyName();
        if (sender.getRole() == AMQPFederationSenderController.Role.ADDRESS_PRODUCER) {
            String address = sender.getServerConsumer().getQueueAddress().toString();
            management.unregisterFromJMX(AMQPFederationManagementSupport.getFederationTargetAddressProducerObjectName(management, remoteNodeId, brokerConnectionName, federationName, manager.getPolicyType().toString(), policyName, address));
            management.unregisterFromRegistry(AMQPFederationManagementSupport.getFederationTargetAddressProducerResourceName(remoteNodeId, brokerConnectionName, federationName, policyName, address));
        } else {
            String fqqn = CompositeAddress.toFullyQualified((String)sender.getServerConsumer().getQueueAddress().toString(), (String)sender.getServerConsumer().getQueueName().toString());
            management.unregisterFromJMX(AMQPFederationManagementSupport.getFederationTargetQueueProducerObjectName(management, remoteNodeId, brokerConnectionName, federationName, manager.getPolicyType().toString(), policyName, fqqn));
            management.unregisterFromRegistry(AMQPFederationManagementSupport.getFederationTargetQueueProducerResourceName(remoteNodeId, brokerConnectionName, federationName, policyName, fqqn));
        }
    }

    public static String getFederationTargetAddressConsumerResourceName(String remoteNodeId, String brokerConnectionName, String federationName, String policyName, String address) {
        return String.format(FEDERATION_SOURCE_CONSUMER_RESOURCE_TEMPLATE, brokerConnectionName, federationName, policyName, address);
    }

    public static String getFederationTargetQueueConsumerResourceName(String remoteNodeId, String brokerConnectionName, String federationName, String policyName, String fqqn) {
        return String.format(FEDERATION_SOURCE_CONSUMER_RESOURCE_TEMPLATE, brokerConnectionName, federationName, policyName, fqqn);
    }

    public static String getFederationTargetAddressProducerResourceName(String remoteNodeId, String brokerConnectionName, String federationName, String policyName, String address) {
        return String.format(FEDERATION_SOURCE_PRODUCER_RESOURCE_TEMPLATE, brokerConnectionName, federationName, policyName, address);
    }

    public static String getFederationTargetQueueProducerResourceName(String remoteNodeId, String brokerConnectionName, String federationName, String policyName, String fqqn) {
        return String.format(FEDERATION_SOURCE_PRODUCER_RESOURCE_TEMPLATE, brokerConnectionName, federationName, policyName, fqqn);
    }

    public static ObjectName getFederationTargetAddressConsumerObjectName(ManagementService management, String remoteNodeId, String brokerConnection, String federationName, String policyType, String policyName, String address) throws Exception {
        return ObjectName.getInstance(String.format("%s,serviceCatagory=federations,federationName=%s,policyType=%s,policyName=%s,linkType=consumers,address=%s", management.getObjectNameBuilder().getRemoteBrokerConnectionBaseObjectNameString(remoteNodeId, brokerConnection), ObjectName.quote(federationName), ObjectName.quote(policyType), ObjectName.quote(policyName), ObjectName.quote(address)));
    }

    public static ObjectName getFederationTargetAddressProducerObjectName(ManagementService management, String remoteNodeId, String brokerConnection, String federationName, String policyType, String policyName, String address) throws Exception {
        return ObjectName.getInstance(String.format("%s,serviceCatagory=federations,federationName=%s,policyType=%s,policyName=%s,linkType=producers,address=%s", management.getObjectNameBuilder().getRemoteBrokerConnectionBaseObjectNameString(remoteNodeId, brokerConnection), ObjectName.quote(federationName), ObjectName.quote(policyType), ObjectName.quote(policyName), ObjectName.quote(address)));
    }

    public static ObjectName getFederationTargetQueueConsumerObjectName(ManagementService management, String remoteNodeId, String brokerConnection, String federationName, String policyType, String policyName, String fqqn) throws Exception {
        return ObjectName.getInstance(String.format("%s,serviceCatagory=federations,federationName=%s,policyType=%s,policyName=%s,linkType=consumers,fqqn=%s", management.getObjectNameBuilder().getRemoteBrokerConnectionBaseObjectNameString(remoteNodeId, brokerConnection), ObjectName.quote(federationName), ObjectName.quote(policyType), ObjectName.quote(policyName), ObjectName.quote(fqqn)));
    }

    public static ObjectName getFederationTargetQueueProducerObjectName(ManagementService management, String remoteNodeId, String brokerConnection, String federationName, String policyType, String policyName, String fqqn) throws Exception {
        return ObjectName.getInstance(String.format("%s,serviceCatagory=federations,federationName=%s,policyType=%s,policyName=%s,linkType=producers,fqqn=%s", management.getObjectNameBuilder().getRemoteBrokerConnectionBaseObjectNameString(remoteNodeId, brokerConnection), ObjectName.quote(federationName), ObjectName.quote(policyType), ObjectName.quote(policyName), ObjectName.quote(fqqn)));
    }
}

