/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.util.Objects;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeManager;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeMetrics;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgePolicy;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgeType;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;

public abstract class AMQPBridgePolicyManager {
    protected final AMQPBridgeMetrics metrics;
    protected final ActiveMQServer server;
    protected final AMQPBridgeManager bridge;
    protected final String policyName;
    protected final AMQPBridgeType policyType;
    protected volatile State state = State.UNINITIALIZED;
    protected boolean connected;
    protected AMQPSessionContext session;

    public AMQPBridgePolicyManager(AMQPBridgeManager bridge, AMQPBridgeMetrics metrics, String policyName, AMQPBridgeType policyType) {
        Objects.requireNonNull(bridge, "The bridge manager instance cannot be null");
        this.bridge = bridge;
        this.server = bridge.getServer();
        this.policyName = policyName;
        this.policyType = policyType;
        this.metrics = metrics;
    }

    public final boolean isStarted() {
        return this.state == State.STARTED;
    }

    protected final boolean isConnected() {
        return this.connected;
    }

    public AMQPBridgeManager getBridgeManager() {
        return this.bridge;
    }

    public AMQPBridgeMetrics getMetrics() {
        return this.metrics;
    }

    public abstract AMQPBridgePolicy getPolicy();

    public final AMQPBridgeType getPolicyType() {
        return this.policyType;
    }

    public final String getPolicyName() {
        return this.policyName;
    }

    public final synchronized void initialize() {
        this.failIfShutdown();
        if (this.state.ordinal() < State.STOPPED.ordinal()) {
            this.state = State.STOPPED;
            this.handleManagerInitialized();
        }
    }

    public final synchronized void start() {
        if (!this.bridge.isStarted()) {
            throw new IllegalStateException("Cannot start a bridge policy manager when the bridge manager is stopped.");
        }
        if (this.state == State.UNINITIALIZED) {
            throw new IllegalStateException("Bridge policy manager has not been initialized");
        }
        this.failIfShutdown();
        if (this.state.ordinal() < State.STARTED.ordinal()) {
            this.state = State.STARTED;
            this.handleManagerStarted();
        }
    }

    public final synchronized void stop() {
        if (this.state == State.UNINITIALIZED) {
            throw new IllegalStateException("Bridge policy manager has not been initialized");
        }
        if (this.state == State.STARTED) {
            this.state = State.STOPPED;
            this.handleManagerStopped();
        }
    }

    public final synchronized void shutdown() {
        if (this.state.ordinal() < State.SHUTDOWN.ordinal()) {
            this.state = State.SHUTDOWN;
            this.handleManagerShutdown();
        }
    }

    public final synchronized void connectionInterrupted() {
        this.connected = false;
        this.handleConnectionInterrupted();
    }

    public final synchronized void connectionRestored(AMQPSessionContext session, AMQPBridgeConfiguration configuration) {
        this.connected = true;
        this.session = session;
        this.handleConnectionRestored(configuration);
    }

    protected final void failIfShutdown() throws IllegalStateException {
        if (this.state == State.SHUTDOWN) {
            throw new IllegalStateException("The bridge policy manager has already been shutdown");
        }
    }

    protected final boolean isActive() {
        return this.connected && this.state == State.STARTED;
    }

    protected abstract void handleManagerInitialized();

    protected abstract void handleManagerStarted();

    protected abstract void handleManagerStopped();

    protected abstract void handleManagerShutdown();

    protected abstract void handleConnectionInterrupted();

    protected abstract void handleConnectionRestored(AMQPBridgeConfiguration var1);

    public static enum State {
        UNINITIALIZED,
        STOPPED,
        STARTED,
        SHUTDOWN;

    }
}

