/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.cli.gui.CommandBuilderTree;
import org.jboss.as.cli.gui.GraphingMenu;
import org.jboss.as.cli.gui.ManagementModelNode;
import org.jboss.as.cli.gui.OperationMenu;

public class ManagementModel
extends JPanel {
    private static final String GENERAL_HELP_TEXT = "Right-click a node to choose an operation.  Close/Open a folder to refresh.  Hover for help.";
    private static final String FILTER_TOOLTIP_HELP = "Display the root nodes containing the given text.";
    private CliGuiContext cliGuiCtx;
    private JTree tree;

    public ManagementModel(CliGuiContext cliGuiCtx) {
        this(new ManagementModelNode(cliGuiCtx), cliGuiCtx);
    }

    public ManagementModel(ManagementModelNode root, CliGuiContext cliGuiCtx) {
        this.cliGuiCtx = cliGuiCtx;
        this.setLayout(new BorderLayout(10, 10));
        this.tree = this.makeTree(root);
        this.add((Component)new JLabel(GENERAL_HELP_TEXT), "North");
        this.add((Component)new JScrollPane(this.tree), "Center");
        this.add((Component)this.makeFilterPanel(this.tree), "South");
    }

    public ManagementModelNode findNode(String address) {
        ManagementModelNode root = (ManagementModelNode)this.tree.getModel().getRoot();
        Enumeration<TreeNode> allNodes = root.depthFirstEnumeration();
        while (allNodes.hasMoreElements()) {
            ManagementModelNode node = (ManagementModelNode)allNodes.nextElement();
            if (!node.addressPath().equals(address)) continue;
            return node;
        }
        return null;
    }

    private JPanel makeFilterPanel(JTree tree) {
        Box filterBox = Box.createHorizontalBox();
        JLabel filterLabel = new JLabel("Filter:");
        filterLabel.setToolTipText(FILTER_TOOLTIP_HELP);
        filterBox.add(filterLabel);
        filterBox.add(Box.createHorizontalStrut(5));
        JTextField filterInput = new JTextField(30);
        filterBox.add(filterInput);
        JButton clearButton = new JButton("Clear");
        clearButton.setToolTipText("Clear the filter");
        clearButton.addActionListener(new ClearFilterListener(filterInput));
        clearButton.setEnabled(false);
        filterInput.getDocument().addDocumentListener(new FilterDocumentListener(tree, clearButton));
        filterBox.add(clearButton);
        JPanel filterPanel = new JPanel(new GridLayout(1, 2));
        filterPanel.add(filterBox);
        filterPanel.add(Box.createGlue());
        return filterPanel;
    }

    private JTree makeTree(ManagementModelNode root) {
        root.explore();
        CommandBuilderTree tree = new CommandBuilderTree(this.cliGuiCtx, new DefaultTreeModel(root));
        tree.getSelectionModel().setSelectionMode(1);
        tree.addTreeExpansionListener(new ManagementTreeExpansionListener((DefaultTreeModel)tree.getModel()));
        tree.addTreeSelectionListener(new ManagementTreeSelectionListener());
        tree.addMouseListener(new ManagementTreeMouseListener(tree));
        return tree;
    }

    public ManagementModelNode getSelectedNode() {
        if (this.tree.getSelectionPath() == null) {
            return null;
        }
        return (ManagementModelNode)this.tree.getSelectionPath().getLastPathComponent();
    }

    private class ClearFilterListener
    implements ActionListener {
        private JTextField filterInput;

        ClearFilterListener(JTextField filterInput) {
            this.filterInput = filterInput;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.filterInput.setText("");
        }
    }

    private class FilterDocumentListener
    implements DocumentListener {
        private JTree tree;
        private JButton clearButton;

        FilterDocumentListener(JTree tree, JButton clearButton) {
            this.tree = tree;
            this.clearButton = clearButton;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            String fieldText = null;
            try {
                fieldText = e.getDocument().getText(0, e.getDocument().getLength());
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
                return;
            }
            this.clearButton.setEnabled(fieldText.length() > 0);
            DefaultTreeModel model = (DefaultTreeModel)this.tree.getModel();
            ManagementModelNode root = (ManagementModelNode)model.getRoot();
            root.explore();
            Enumeration<TreeNode> nodes = root.children();
            ArrayList<ManagementModelNode> removeList = new ArrayList<ManagementModelNode>();
            while (nodes.hasMoreElements()) {
                ManagementModelNode node = (ManagementModelNode)nodes.nextElement();
                if (node.getUserObject().toString().contains(fieldText)) continue;
                removeList.add(node);
            }
            for (ManagementModelNode node : removeList) {
                root.remove(node);
            }
            model.nodeStructureChanged(root);
        }
    }

    private class ManagementTreeExpansionListener
    implements TreeExpansionListener {
        private DefaultTreeModel treeModel;

        public ManagementTreeExpansionListener(DefaultTreeModel treeModel) {
            this.treeModel = treeModel;
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent tee) {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent tee) {
            ManagementModelNode node = (ManagementModelNode)tee.getPath().getLastPathComponent();
            node.explore();
            this.treeModel.nodeStructureChanged(node);
        }
    }

    private class ManagementTreeSelectionListener
    implements TreeSelectionListener {
        private ManagementTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent tse) {
            ManagementModelNode selected = (ManagementModelNode)tse.getPath().getLastPathComponent();
            ManagementModel.this.cliGuiCtx.getCommandLine().getCmdText().setText(selected.addressPath());
        }
    }

    private class ManagementTreeMouseListener
    extends MouseAdapter {
        private JTree tree;
        private OperationMenu operationMenu;
        private GraphingMenu graphingMenu;

        public ManagementTreeMouseListener(JTree tree) {
            this.tree = tree;
            this.operationMenu = new OperationMenu(ManagementModel.this.cliGuiCtx, tree);
            this.graphingMenu = new GraphingMenu(ManagementModel.this.cliGuiCtx, tree);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            this.showPopup(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            this.showPopup(e);
        }

        private void showPopup(MouseEvent e) {
            int selRow = this.tree.getRowForLocation(e.getX(), e.getY());
            if (selRow == -1) {
                return;
            }
            TreePath selPath = this.tree.getPathForLocation(e.getX(), e.getY());
            this.tree.setSelectionPath(selPath);
            ManagementModelNode node = (ManagementModelNode)selPath.getLastPathComponent();
            ManagementModelNode.UserObject usrObj = (ManagementModelNode.UserObject)node.getUserObject();
            ManagementModelNode.AttributeDescription attrDesc = usrObj.getAttributeDescription();
            if (attrDesc == null || !attrDesc.isGraphable()) {
                this.operationMenu.show(node, e.getX(), e.getY());
            }
        }
    }
}

