/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.infinispan.remote;

import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.wildfly.clustering.cache.infinispan.remote.RemoteCacheConfiguration;
import org.wildfly.clustering.function.Consumer;
import org.wildfly.clustering.server.cache.CacheFactory;
import org.wildfly.clustering.server.cache.CacheStrategy;
import org.wildfly.clustering.server.local.manager.SimpleIdentifierFactoryService;
import org.wildfly.clustering.server.manager.IdentifierFactoryService;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.Session;
import org.wildfly.clustering.session.SessionManager;
import org.wildfly.clustering.session.SessionManagerConfiguration;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.session.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.session.cache.CachedSessionManager;
import org.wildfly.clustering.session.cache.DetachedSession;
import org.wildfly.clustering.session.cache.SessionFactory;
import org.wildfly.clustering.session.cache.attributes.MarshalledValueMarshallerSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.session.cache.attributes.SessionAttributesFactory;
import org.wildfly.clustering.session.cache.attributes.coarse.ImmutableSessionActivationNotifier;
import org.wildfly.clustering.session.cache.attributes.coarse.SessionActivationNotifier;
import org.wildfly.clustering.session.cache.attributes.fine.ImmutableSessionAttributeActivationNotifier;
import org.wildfly.clustering.session.cache.attributes.fine.SessionAttributeActivationNotifier;
import org.wildfly.clustering.session.cache.metadata.SessionMetaDataFactory;
import org.wildfly.clustering.session.cache.metadata.fine.SessionMetaDataEntry;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionFactory;
import org.wildfly.clustering.session.infinispan.remote.HotRodSessionManager;
import org.wildfly.clustering.session.infinispan.remote.attributes.CoarseSessionAttributesFactory;
import org.wildfly.clustering.session.infinispan.remote.attributes.FineSessionAttributesFactory;
import org.wildfly.clustering.session.infinispan.remote.metadata.HotRodSessionMetaDataFactory;
import org.wildfly.clustering.session.spec.SessionEventListenerSpecificationProvider;
import org.wildfly.clustering.session.spec.SessionSpecificationProvider;

public class HotRodSessionManagerFactory<DC, SC>
implements SessionManagerFactory<DC, SC> {
    private final RemoteCacheConfiguration configuration;
    private final SessionFactory<DC, SessionMetaDataEntry<SC>, Object, SC> sessionFactory;
    private final Collection<java.util.function.Consumer<ImmutableSession>> expirationListeners = new CopyOnWriteArraySet<java.util.function.Consumer<ImmutableSession>>();

    public <S, L> HotRodSessionManagerFactory(final Configuration<S, DC, SC, L> configuration) {
        this.configuration = configuration.getCacheConfiguration();
        final HotRodSessionMetaDataFactory metaDataFactory = new HotRodSessionMetaDataFactory(this.configuration);
        final SessionAttributesFactory<DC, ?> attributesFactory = this.createSessionAttributesFactory(configuration);
        Consumer listeners = Consumer.acceptAll(this.expirationListeners);
        this.sessionFactory = new HotRodSessionFactory(new HotRodSessionFactory.Configuration<DC, Object, SC>(){
            final /* synthetic */ java.util.function.Consumer val$listeners;
            final /* synthetic */ HotRodSessionManagerFactory this$0;
            {
                this.val$listeners = consumer;
                this.this$0 = this$0;
            }

            public SessionMetaDataFactory<SessionMetaDataEntry<SC>> getSessionMetaDataFactory() {
                return metaDataFactory;
            }

            public SessionAttributesFactory<DC, Object> getSessionAttributesFactory() {
                return attributesFactory;
            }

            public Supplier<SC> getSessionContextFactory() {
                return configuration.getSessionManagerFactoryConfiguration().getSessionContextFactory();
            }

            @Override
            public RemoteCacheConfiguration getCacheConfiguration() {
                return configuration.getCacheConfiguration();
            }

            @Override
            public java.util.function.Consumer<ImmutableSession> getSessionExpirationListener() {
                return this.val$listeners;
            }
        });
    }

    public SessionManager<SC> createSessionManager(SessionManagerConfiguration<DC> configuration) {
        RemoteCacheConfiguration cacheConfiguration = this.configuration;
        SessionFactory<DC, SessionMetaDataEntry<SC>, Object, SC> sessionFactory = this.sessionFactory;
        SimpleIdentifierFactoryService identifierFactory = new SimpleIdentifierFactoryService((Supplier)configuration.getIdentifierFactory());
        final Collection<java.util.function.Consumer<ImmutableSession>> expirationListeners = this.expirationListeners;
        final java.util.function.Consumer expirationListener = configuration.getExpirationListener();
        AtomicReference<3> reference = new AtomicReference<3>();
        BiFunction<String, Object, Session> detachedSessionFactory = (id, context) -> new DetachedSession(reference::getPlain, id, context);
        CachedSessionManager manager = new CachedSessionManager<SC>(this, (SessionManager)new HotRodSessionManager(new HotRodSessionManager.Configuration<DC, SessionMetaDataEntry<SC>, Object, SC>(){
            final /* synthetic */ IdentifierFactoryService val$identifierFactory;
            final /* synthetic */ SessionFactory val$sessionFactory;
            final /* synthetic */ BiFunction val$detachedSessionFactory;
            final /* synthetic */ SessionManagerConfiguration val$configuration;
            final /* synthetic */ RemoteCacheConfiguration val$cacheConfiguration;
            final /* synthetic */ HotRodSessionManagerFactory this$0;
            {
                this.val$identifierFactory = identifierFactoryService;
                this.val$sessionFactory = sessionFactory;
                this.val$detachedSessionFactory = biFunction;
                this.val$configuration = sessionManagerConfiguration;
                this.val$cacheConfiguration = remoteCacheConfiguration;
                this.this$0 = this$0;
            }

            public IdentifierFactoryService<String> getIdentifierFactory() {
                return this.val$identifierFactory;
            }

            public SessionFactory<DC, SessionMetaDataEntry<SC>, Object, SC> getSessionFactory() {
                return this.val$sessionFactory;
            }

            public BiFunction<String, SC, Session<SC>> getDetachedSessionFactory() {
                return this.val$detachedSessionFactory;
            }

            public DC getContext() {
                return this.val$configuration.getContext();
            }

            public java.util.function.Consumer<ImmutableSession> getExpirationListener() {
                return this.val$configuration.getExpirationListener();
            }

            public Duration getTimeout() {
                return this.val$configuration.getTimeout();
            }

            @Override
            public RemoteCacheConfiguration getCacheConfiguration() {
                return this.val$cacheConfiguration;
            }
        }), (CacheFactory)CacheStrategy.CONCURRENT){
            final /* synthetic */ HotRodSessionManagerFactory this$0;
            {
                this.this$0 = this$0;
                super(manager, cacheFactory);
            }

            public void start() {
                expirationListeners.add(expirationListener);
                super.start();
            }

            public void stop() {
                try {
                    super.stop();
                }
                finally {
                    expirationListeners.remove(expirationListener);
                }
            }
        };
        reference.setPlain(manager);
        return manager;
    }

    public void close() {
        this.sessionFactory.close();
    }

    private <S, L> SessionAttributesFactory<DC, ?> createSessionAttributesFactory(Configuration<S, DC, SC, L> configuration) {
        switch (configuration.getSessionManagerFactoryConfiguration().getAttributePersistenceStrategy()) {
            case FINE: {
                BiFunction<ImmutableSession, Object, SessionAttributeActivationNotifier> passivationNotifierFactory = (session, context) -> new ImmutableSessionAttributeActivationNotifier(configuration.getSessionSpecificationProvider(), configuration.getSessionEventListenerSpecificationProvider(), session, context);
                return new FineSessionAttributesFactory(new MarshalledValueMarshallerSessionAttributesFactoryConfiguration(configuration.getSessionManagerFactoryConfiguration()), passivationNotifierFactory, configuration.getCacheConfiguration());
            }
            case COARSE: {
                BiFunction<ImmutableSession, Object, SessionActivationNotifier> passivationNotifierFactory = (session, context) -> new ImmutableSessionActivationNotifier(configuration.getSessionSpecificationProvider(), configuration.getSessionEventListenerSpecificationProvider(), session, context);
                return new CoarseSessionAttributesFactory(new MarshalledValueMarshallerSessionAttributesFactoryConfiguration(configuration.getSessionManagerFactoryConfiguration()), passivationNotifierFactory, configuration.getCacheConfiguration());
            }
        }
        throw new IllegalStateException();
    }

    public static interface Configuration<S, DC, SC, L> {
        public SessionManagerFactoryConfiguration<SC> getSessionManagerFactoryConfiguration();

        public SessionSpecificationProvider<S, DC> getSessionSpecificationProvider();

        public SessionEventListenerSpecificationProvider<S, L> getSessionEventListenerSpecificationProvider();

        public RemoteCacheConfiguration getCacheConfiguration();
    }
}

