/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.registry.otlp;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.Histogram;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.registry.otlp.OtlpConfig;
import io.micrometer.registry.otlp.OtlpHistogramSupport;
import io.micrometer.registry.otlp.OtlpStepBucketHistogram;
import io.micrometer.registry.otlp.OtlpStepTuple2;
import io.micrometer.registry.otlp.StepMax;
import io.micrometer.registry.otlp.internal.Base2ExponentialHistogram;
import io.micrometer.registry.otlp.internal.ExponentialHistogramSnapShot;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

class OtlpStepTimer
extends AbstractTimer
implements OtlpHistogramSupport {
    private final LongAdder count = new LongAdder();
    private final LongAdder total = new LongAdder();
    private final OtlpStepTuple2<Long, Long> countTotal;
    private final StepMax max;

    OtlpStepTimer(Meter.Id id, Clock clock, PauseDetector pauseDetector, Histogram histogram, OtlpConfig otlpConfig) {
        super(id, clock, pauseDetector, otlpConfig.baseTimeUnit(), histogram);
        this.countTotal = new OtlpStepTuple2<Long, Long>(clock, otlpConfig.step().toMillis(), 0L, 0L, this.count::sumThenReset, this.total::sumThenReset);
        this.max = new StepMax(clock, otlpConfig.step().toMillis());
    }

    protected void recordNonNegative(long amount, TimeUnit unit) {
        long nanoAmount = (long)TimeUtils.convert((double)amount, (TimeUnit)unit, (TimeUnit)TimeUnit.NANOSECONDS);
        this.count.add(1L);
        this.total.add(nanoAmount);
        this.max.record(nanoAmount);
    }

    public long count() {
        return (Long)this.countTotal.poll1();
    }

    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit((double)((Long)this.countTotal.poll2()).longValue(), (TimeUnit)unit);
    }

    public double max(TimeUnit unit) {
        return TimeUtils.nanosToUnit((double)((Double)this.max.poll()), (TimeUnit)unit);
    }

    void _closingRollover() {
        this.countTotal._closingRollover();
        this.max._closingRollover();
        if (this.histogram instanceof OtlpStepBucketHistogram) {
            ((OtlpStepBucketHistogram)this.histogram)._closingRollover();
        } else if (this.histogram instanceof Base2ExponentialHistogram) {
            this.histogram.close();
        }
    }

    @Override
    @Nullable
    public ExponentialHistogramSnapShot getExponentialHistogramSnapShot() {
        if (this.histogram instanceof Base2ExponentialHistogram) {
            return ((Base2ExponentialHistogram)this.histogram).getLatestExponentialHistogramSnapshot();
        }
        return null;
    }
}

