/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jta.recovery.jts;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.objectstore.RecoveryStore;
import com.arjuna.ats.arjuna.objectstore.StoreManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.jta.transaction.arjunacore.jca.SubordinationManager;
import com.arjuna.ats.internal.jta.transaction.jts.subordinate.jca.coordinator.ServerTransaction;
import com.arjuna.ats.internal.jta.utils.jtaxLogger;
import java.io.IOException;
import javax.transaction.xa.XAException;

public class JCAServerTransactionRecoveryModule
implements RecoveryModule {
    @Override
    public void periodicWorkFirstPass() {
        try {
            RecoveryStore recoveryStore = StoreManager.getRecoveryStore();
            InputObjectState states = new InputObjectState();
            if (recoveryStore.allObjUids(ServerTransaction.getType(), states) && states.notempty()) {
                boolean finished = false;
                do {
                    Uid uid;
                    if ((uid = UidHelper.unpackFrom(states)).notEquals(Uid.nullUid())) {
                        SubordinationManager.getTransactionImporter().recoverTransaction(uid);
                        continue;
                    }
                    finished = true;
                } while (!finished);
            }
        }
        catch (ObjectStoreException | IOException | XAException e) {
            jtaxLogger.i18NLogger.warn_jtax_transaction_jts_ex(e);
        }
    }

    @Override
    public void periodicWorkSecondPass() {
    }
}

