/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modcluster.config.builder;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.modcluster.config.AdvertiseConfiguration;
import org.jboss.modcluster.config.builder.AbstractConfigurationBuilder;
import org.jboss.modcluster.config.builder.ConfigurationBuilder;
import org.jboss.modcluster.config.builder.Creator;
import org.jboss.modcluster.config.impl.AdvertiseConfigurationImpl;

public class AdvertiseConfigurationBuilder
extends AbstractConfigurationBuilder
implements Creator<AdvertiseConfiguration> {
    private InetSocketAddress advertiseSocketAddress = AdvertiseConfiguration.DEFAULT_SOCKET_ADDRESS;
    private NetworkInterface advertiseInterface;
    private String advertiseSecurityKey;
    private ThreadFactory advertiseThreadFactory = Executors.defaultThreadFactory();

    AdvertiseConfigurationBuilder(ConfigurationBuilder parentBuilder) {
        super(parentBuilder);
    }

    public AdvertiseConfigurationBuilder setAdvertiseSocketAddress(InetSocketAddress advertiseSocketAddress) {
        this.advertiseSocketAddress = advertiseSocketAddress;
        return this;
    }

    public AdvertiseConfigurationBuilder setAdvertiseInterface(NetworkInterface advertiseInterface) {
        this.advertiseInterface = advertiseInterface;
        return this;
    }

    @Deprecated
    public AdvertiseConfigurationBuilder setAdvertiseInterface(InetAddress advertiseInterface) {
        try {
            this.advertiseInterface = NetworkInterface.getByInetAddress(advertiseInterface);
        }
        catch (SocketException e) {
            throw new RuntimeException();
        }
        return this;
    }

    public AdvertiseConfigurationBuilder setAdvertiseSecurityKey(String advertiseSecurityKey) {
        this.advertiseSecurityKey = advertiseSecurityKey;
        return this;
    }

    public AdvertiseConfigurationBuilder setAdvertiseThreadFactory(ThreadFactory advertiseThreadFactory) {
        this.advertiseThreadFactory = advertiseThreadFactory;
        return this;
    }

    @Override
    public AdvertiseConfiguration create() {
        return new AdvertiseConfigurationImpl(this.advertiseSocketAddress, this.advertiseInterface, this.advertiseSecurityKey, this.advertiseThreadFactory);
    }
}

