/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem.remote;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.clustering.infinispan.subsystem.remote.RemoteCacheRuntimeResourceDefinitionRegistrar;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.wildfly.clustering.server.Registrar;
import org.wildfly.clustering.server.Registration;
import org.wildfly.subsystem.resource.ChildResourceProvider;
import org.wildfly.subsystem.resource.DynamicResource;

public class RemoteCacheContainerResource
extends DynamicResource
implements Registrar<String> {
    private static final String CHILD_TYPE = RemoteCacheRuntimeResourceDefinitionRegistrar.REGISTRATION.getPathElement().getKey();

    public RemoteCacheContainerResource(Resource resource) {
        this(resource, Collections.singletonMap(CHILD_TYPE, new ChildResourceProvider(){
            private final Set<String> caches = ConcurrentHashMap.newKeySet();

            public Resource getChild(String name) {
                return this.caches.contains(name) ? PlaceholderResource.INSTANCE : null;
            }

            public Set<String> getChildren() {
                return this.caches;
            }
        }));
    }

    private RemoteCacheContainerResource(Resource resource, Map<String, ChildResourceProvider> providers) {
        super(resource, providers, RemoteCacheContainerResource::new);
    }

    public Registration register(final String cache) {
        final ChildResourceProvider handler = this.apply(CHILD_TYPE);
        handler.getChildren().add(cache);
        return new Registration(){

            public void close() {
                handler.getChildren().remove(cache);
            }
        };
    }
}

