/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.ConfigurationResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.TransportResourceRegistration;
import org.jboss.as.clustering.infinispan.subsystem.UnaryServiceDescriptorFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.capability.UnaryCapabilityNameResolver;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.server.service.CacheContainerServiceInstallerProvider;
import org.wildfly.clustering.server.service.ClusteringServiceDescriptor;
import org.wildfly.clustering.server.service.ProvidedBiServiceInstallerProvider;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.resource.ResourceModelResolver;
import org.wildfly.subsystem.resource.operation.ResourceOperationRuntimeHandler;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;

public abstract class TransportResourceDefinitionRegistrar
extends ConfigurationResourceDefinitionRegistrar<TransportConfiguration, TransportConfigurationBuilder>
implements ResourceServiceConfigurator {
    static final UnaryServiceDescriptor<TransportConfiguration> SERVICE_DESCRIPTOR = UnaryServiceDescriptorFactory.createServiceDescriptor(TransportResourceRegistration.WILDCARD, TransportConfiguration.class);
    static final RuntimeCapability<Void> CAPABILITY = RuntimeCapability.Builder.of(SERVICE_DESCRIPTOR).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.PARENT).build();
    static final RuntimeCapability<Void> COMMAND_DISPATCHER_FACTORY = RuntimeCapability.Builder.of((UnaryServiceDescriptor)ClusteringServiceDescriptor.COMMAND_DISPATCHER_FACTORY).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.PARENT).setAllowMultipleRegistrations(true).build();
    static final RuntimeCapability<Void> GROUP = RuntimeCapability.Builder.of((UnaryServiceDescriptor)ClusteringServiceDescriptor.GROUP).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.PARENT).setAllowMultipleRegistrations(true).build();
    private final ResourceModelResolver<String> groupNameResolver;

    public TransportResourceDefinitionRegistrar(Configurator configurator) {
        super(configurator);
        this.groupNameResolver = configurator;
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)super.apply(builder).addCapabilities(List.of(COMMAND_DISPATCHER_FACTORY, GROUP));
    }

    @Override
    public ResourceOperationRuntimeHandler get() {
        return ResourceOperationRuntimeHandler.combine((ResourceOperationRuntimeHandler[])new ResourceOperationRuntimeHandler[]{super.get(), ResourceOperationRuntimeHandler.configureService((ResourceServiceConfigurator)this)});
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress containerAddress = address.getParent();
        String name = containerAddress.getLastElement().getValue();
        String groupName = (String)this.groupNameResolver.resolve(context, model);
        LinkedList installers = new LinkedList();
        new ProvidedBiServiceInstallerProvider(CacheContainerServiceInstallerProvider.class, CacheContainerServiceInstallerProvider.class.getClassLoader()).apply(name, groupName).forEach(installers::add);
        return ResourceServiceInstaller.combine(installers);
    }

    static interface Configurator
    extends ConfigurationResourceDefinitionRegistrar.Configurator<TransportConfiguration>,
    ResourceModelResolver<String> {
        @Override
        default public RuntimeCapability<Void> getCapability() {
            return CAPABILITY;
        }
    }
}

