/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.function.Consumer;
import java.util.function.Function;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.infinispan.cache.LazyCache;
import org.jboss.as.controller.RequirementServiceTarget;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.service.descriptor.BinaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class LazyCacheServiceInstaller
implements ServiceInstaller {
    static final BinaryServiceDescriptor<Cache<?, ?>> SERVICE_DESCRIPTOR = BinaryServiceDescriptor.of((String)(InfinispanServiceDescriptor.CACHE.getName() + ".lazy"), (Class)InfinispanServiceDescriptor.CACHE.getType());
    private final BinaryServiceConfiguration config;

    LazyCacheServiceInstaller(BinaryServiceConfiguration config) {
        this.config = config;
    }

    public ServiceController<?> install(RequirementServiceTarget target) {
        final String cacheName = this.config.getChildName();
        ServiceDependency cache = this.config.getServiceDependency(InfinispanServiceDescriptor.CACHE_CONTAINER).map(new Function<EmbeddedCacheManager, Cache<?, ?>>(){

            @Override
            public Cache<?, ?> apply(EmbeddedCacheManager manager) {
                return new LazyCache(manager, cacheName);
            }
        });
        return ((ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((ServiceDependency)cache).provides(this.config.resolveServiceName(SERVICE_DESCRIPTOR))).requires((Consumer)this.config.getServiceDependency(InfinispanServiceDescriptor.CACHE))).build()).install((ServiceTarget)target);
    }
}

