/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.permission;

import java.security.Permission;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import org.wildfly.security.permission.AbstractNamedPermission;
import org.wildfly.security.permission.AbstractPermission;
import org.wildfly.security.permission.NameSetPermissionCollection;
import org.wildfly.security.util.EnumerationIterator;
import org.wildfly.security.util.StringEnumeration;

final class LongNameSetPermissionCollection
extends NameSetPermissionCollection {
    private final AtomicLong bitSet = new AtomicLong();

    LongNameSetPermissionCollection(AbstractPermission<?> sourcePermission, StringEnumeration nameEnumeration) {
        super(sourcePermission, nameEnumeration);
    }

    @Override
    protected void doAdd(AbstractPermission<?> permission) {
        long oldVal;
        long setBits = this.getBitsForName(permission);
        AtomicLong bitSet = this.bitSet;
        do {
            if (((oldVal = bitSet.get()) & setBits) != setBits) continue;
            return;
        } while (!bitSet.compareAndSet(oldVal, oldVal | setBits));
    }

    @Override
    public boolean implies(Permission permission) {
        if (permission.getClass() != this.getSourcePermission().getClass()) {
            return false;
        }
        long testBits = this.getBitsForName(permission);
        return (this.bitSet.get() & testBits) == testBits;
    }

    @Override
    public int size() {
        int size = Long.bitCount(this.bitSet.get());
        return size == this.getNameEnumeration().size() ? 1 : size;
    }

    @Override
    public EnumerationIterator<Permission> iterator() {
        return new Iter(this.bitSet.get());
    }

    public EnumerationIterator<Permission> elements() {
        return this.iterator();
    }

    private long getBitsForName(Permission permission) {
        String name = permission.getName();
        StringEnumeration nameEnumeration = this.getNameEnumeration();
        long bits = "*".equals(name) ? (1L << nameEnumeration.size()) - 1L : 1L << nameEnumeration.indexOf(name);
        return bits;
    }

    private class Iter
    implements EnumerationIterator<Permission> {
        private long bits;

        Iter(long bits) {
            this.bits = bits;
        }

        @Override
        public boolean hasMoreElements() {
            return this.bits != 0L;
        }

        @Override
        public Permission nextElement() {
            long bits = this.bits;
            if (bits == 0L) {
                throw new NoSuchElementException();
            }
            if (Long.bitCount(bits) == LongNameSetPermissionCollection.this.getNameEnumeration().size()) {
                this.bits = 0L;
                return ((AbstractNamedPermission)LongNameSetPermissionCollection.this.getSourcePermission()).withName("*");
            }
            long bit = Long.lowestOneBit(bits);
            this.bits = bits & (bit ^ 0xFFFFFFFFFFFFFFFFL);
            return this.permissionFor(Long.numberOfTrailingZeros(bit));
        }

        @Override
        public boolean hasNext() {
            return this.hasMoreElements();
        }

        @Override
        public Permission next() {
            return this.nextElement();
        }

        private Permission permissionFor(int id) {
            return ((AbstractNamedPermission)LongNameSetPermissionCollection.this.getSourcePermission()).withName(LongNameSetPermissionCollection.this.getNameEnumeration().nameOf(id));
        }
    }
}

