/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.Util;

public class PinnedVThreads {
    protected int cores;
    protected int pinned;
    protected long timeout = 5000L;

    public int cores() {
        return this.cores;
    }

    public void cores(int cores) {
        this.cores = cores;
    }

    public int pinned() {
        return this.pinned;
    }

    public void pinned(int pinned) {
        this.pinned = pinned;
    }

    public long timeout() {
        return this.timeout;
    }

    public void timeout(long t) {
        this.timeout = t;
    }

    public void start() throws IOException, InterruptedException {
        int available_cores = Runtime.getRuntime().availableProcessors();
        if (this.cores > 0) {
            String s = String.valueOf(this.cores);
            System.setProperty("jdk.virtualThreadScheduler.parallelism", s);
            System.out.printf("-- set FJP parallelism to %d cores (available: %d)\n", this.cores, available_cores);
        } else {
            System.out.printf("-- FJP parallelism will use %d cores\n", available_cores);
        }
        System.out.printf("-- %d virtual threads will be pinned\n", this.pinned);
        Object factory = new DefaultThreadFactory("test", true, false).useVirtualThreads(true);
        Object[] locks = new Object[this.pinned];
        for (int i = 0; i < this.pinned; ++i) {
            locks[i] = new Object();
            Object lock = locks[i];
            Thread t = factory.newThread(() -> {
                Object object = lock;
                synchronized (object) {
                    System.out.printf("[%s] parking\n", Thread.currentThread());
                    LockSupport.park();
                }
            }, "pinner-" + i);
            t.start();
        }
        ArrayList<Thread> workers = new ArrayList<Thread>(this.pinned);
        AtomicInteger count = new AtomicInteger();
        for (int i = 0; i < this.pinned; ++i) {
            Runnable r = () -> PinnedVThreads.doWork(count);
            Thread t = factory.newThread(r, "worker-" + i);
            workers.add(t);
            t.start();
        }
        Util.waitUntilTrue(this.timeout, 500L, () -> count.get() == this.pinned);
        if (count.get() == this.pinned) {
            System.out.printf("\n** SUCCESS: %d worker threads completed (expected: %d)\n", count.get(), this.pinned);
        } else {
            System.err.printf("\n** FAILURE: %d worker threads completed (expected: %d)\n", count.get(), this.pinned);
        }
    }

    protected static void doWork(AtomicInteger cnt) {
        long start = System.currentTimeMillis();
        Util.sleepRandom(1000L, 5000L);
        long time = System.currentTimeMillis() - start;
        System.out.printf("[%s] done, slept for %,d ms\n", Thread.currentThread(), time);
        cnt.incrementAndGet();
    }

    public static void main(String[] args) throws Exception {
        PinnedVThreads test = new PinnedVThreads();
        for (int i = 0; i < args.length; ++i) {
            if ("-cores".equals(args[i])) {
                test.cores(Integer.parseInt(args[++i]));
                continue;
            }
            if ("-pinned".equals(args[i])) {
                test.pinned(Integer.parseInt(args[++i]));
                continue;
            }
            if ("-timeout".equals(args[i])) {
                test.timeout(Long.parseLong(args[++i]));
                continue;
            }
            System.out.printf("%s [-cores <number of cores>] [-pinned <number of virtual threads pinned>] [-timeout <msecs>]\n", PinnedVThreads.class.getSimpleName());
            return;
        }
        test.start();
    }
}

