/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.GroupRequest;
import org.jgroups.blocks.Request;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.Response;
import org.jgroups.blocks.UnicastRequest;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.relay.SiteMaster;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.Bits;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.RpcStats;
import org.jgroups.util.Util;

public class RequestCorrelator {
    protected Protocol down_prot;
    protected final Map<Long, Request<?>> requests = Util.createConcurrentMap();
    protected static final AtomicLong REQUEST_ID = new AtomicLong(1L);
    protected RequestHandler request_handler;
    protected short corr_id = ClassConfigurator.getProtocolId(this.getClass());
    protected Address local_addr;
    protected volatile View view;
    protected boolean started;
    protected boolean async_dispatching;
    protected boolean wrap_exceptions;
    protected boolean async_rsp_handling = !Util.virtualThreadsAvailable();
    protected final MyProbeHandler probe_handler = new MyProbeHandler();
    protected final ForkJoinPool common_pool = ForkJoinPool.commonPool();
    protected volatile boolean rpcstats;
    protected final RpcStats rpc_stats = new RpcStats(false);
    protected final AverageMinMax avg_req_delivery = (AverageMinMax)new AverageMinMax(1024).unit(TimeUnit.NANOSECONDS);
    protected final AverageMinMax avg_rsp_delivery = (AverageMinMax)new AverageMinMax(1024).unit(TimeUnit.NANOSECONDS);
    protected static final Log log = LogFactory.getLog(RequestCorrelator.class);

    public RequestCorrelator(Protocol down_prot, RequestHandler handler, Address local_addr) {
        this.down_prot = down_prot;
        this.local_addr = local_addr;
        this.request_handler = handler;
        this.start();
    }

    public void setRequestHandler(RequestHandler handler) {
        this.request_handler = handler;
        this.start();
    }

    public Address getLocalAddress() {
        return this.local_addr;
    }

    public RequestCorrelator setLocalAddress(Address a) {
        this.local_addr = a;
        return this;
    }

    public boolean asyncDispatching() {
        return this.async_dispatching;
    }

    public RequestCorrelator asyncDispatching(boolean flag) {
        this.async_dispatching = flag;
        return this;
    }

    public boolean asyncRspHandling() {
        return this.async_rsp_handling;
    }

    public RequestCorrelator asyncRspHandling(boolean f) {
        this.async_rsp_handling = f;
        return this;
    }

    public boolean wrapExceptions() {
        return this.wrap_exceptions;
    }

    public RequestCorrelator wrapExceptions(boolean flag) {
        this.wrap_exceptions = flag;
        return this;
    }

    public boolean rpcStats() {
        return this.rpcstats;
    }

    public RequestCorrelator rpcStats(boolean b) {
        this.rpcstats = b;
        return this;
    }

    public <T> void sendMulticastRequest(Collection<Address> dest_mbrs, Message msg, Request<T> req, RequestOptions opts) throws Exception {
        Header hdr = opts.hasExclusionList() ? new MultiDestinationHeader(0, 0L, this.corr_id, opts.exclusionList()) : new Header(0, 0L, this.corr_id);
        msg.putHeader(this.corr_id, hdr).setFlag(opts.flags(), false, true).setFlag(opts.transientFlags(), true, true);
        if (req != null) {
            this.addEntry(req, hdr, false);
        } else if (this.rpcstats) {
            if (opts.anycasting()) {
                this.rpc_stats.addAnycast(false, 0L, dest_mbrs);
            } else {
                this.rpc_stats.add(RpcStats.Type.MULTICAST, null, false, 0L);
            }
        }
        if (opts.anycasting()) {
            this.sendAnycastRequest(msg, dest_mbrs);
        } else {
            this.down_prot.down(msg);
        }
    }

    public <T> void sendUnicastRequest(Message msg, Request<T> req, RequestOptions opts) throws Exception {
        Address dest = msg.getDest();
        Header hdr = new Header(0, 0L, this.corr_id);
        msg.putHeader(this.corr_id, hdr).setFlag(opts.flags(), false, true).setFlag(opts.transientFlags(), true, true);
        if (req != null) {
            this.addEntry(req, hdr, true);
        } else if (this.rpcstats) {
            this.rpc_stats.add(RpcStats.Type.UNICAST, dest, false, 0L);
        }
        this.down_prot.down(msg);
    }

    public void done(long id) {
        this.removeEntry(id);
    }

    public boolean receive(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.receiveView((View)evt.getArg());
                break;
            }
            case 104: {
                SiteMaster site_master = (SiteMaster)evt.getArg();
                String site = site_master.getSite();
                this.setSiteUnreachable(site);
                break;
            }
            case 105: {
                this.setMemberUnreachable((Address)evt.arg());
            }
        }
        return false;
    }

    public final void start() {
        this.started = true;
    }

    public void stop() {
        this.started = false;
        this.requests.values().forEach(Request::transportClosed);
        this.requests.clear();
    }

    public void registerProbeHandler(TP transport) {
        if (transport != null) {
            transport.registerProbeHandler(this.probe_handler);
        }
    }

    public void unregisterProbeHandler(TP transport) {
        if (transport != null) {
            transport.unregisterProbeHandler(this.probe_handler);
        }
    }

    public void setSiteUnreachable(String site) {
        this.requests.values().stream().filter(Objects::nonNull).forEach(req -> req.siteUnreachable(site));
    }

    public void setMemberUnreachable(Address mbr) {
        this.requests.values().stream().filter(Objects::nonNull).forEach(req -> req.memberUnreachable(mbr));
    }

    public void receiveView(View new_view) {
        this.view = new_view;
        this.requests.values().stream().filter(Objects::nonNull).forEach(req -> req.viewChange(new_view, true));
        this.rpc_stats.retainAll(new_view.getMembers());
    }

    public boolean receiveMessage(Message msg) {
        Header hdr = (Header)msg.getHeader(this.corr_id);
        if (hdr == null || hdr.corrId != this.corr_id) {
            log.trace("ID of request correlator header (%s) is different from ours (%d). Msg not accepted, passed up", hdr != null ? String.valueOf(hdr.corrId) : "null", this.corr_id);
            return false;
        }
        if (this.skip(hdr, msg.src())) {
            return true;
        }
        this.dispatch(msg, hdr);
        return true;
    }

    public void receiveMessageBatch(MessageBatch batch) {
        if (!this.async_rsp_handling) {
            this.iterate(batch, true, true, true);
            return;
        }
        this.iterate(batch, true, false, true);
        this.iterate(batch, false, true, false);
    }

    protected void iterate(MessageBatch batch, boolean skip_excluded_msgs, boolean process_reqs, boolean process_rsps) {
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            Header hdr = (Header)msg.getHeader(this.corr_id);
            if (hdr == null || hdr.corrId != this.corr_id) continue;
            if (skip_excluded_msgs && this.skip(hdr, msg.src())) {
                it.remove();
                continue;
            }
            switch (hdr.type) {
                case 0: {
                    if (!process_reqs) break;
                    this.dispatch(msg, hdr);
                    break;
                }
                case 1: 
                case 2: {
                    if (!process_rsps) break;
                    if (this.async_rsp_handling) {
                        this.common_pool.execute(() -> this.dispatch(msg, hdr));
                        break;
                    }
                    this.dispatch(msg, hdr);
                }
            }
        }
    }

    protected boolean skip(Header hdr, Address sender) {
        if (hdr instanceof MultiDestinationHeader) {
            Address[] exclusion_list = ((MultiDestinationHeader)hdr).exclusion_list;
            if (this.local_addr != null && Util.contains(this.local_addr, exclusion_list)) {
                log.trace("%s: dropped req from %s as we are in the exclusion list, hdr=%s", this.local_addr, sender, hdr);
                return true;
            }
        }
        return false;
    }

    protected void sendAnycastRequest(Message req, Collection<Address> dest_mbrs) {
        boolean first = true;
        for (Address mbr : dest_mbrs) {
            Message copy = (first ? req : req.copy(true, true)).setDest(mbr);
            first = false;
            if (!mbr.equals(this.local_addr) && copy.isFlagSet(Message.TransientFlag.DONT_LOOPBACK)) {
                copy.clearFlag(Message.TransientFlag.DONT_LOOPBACK);
            }
            this.down_prot.down(copy);
        }
    }

    protected <T> void addEntry(Request<T> req, Header hdr, boolean unicast) {
        Request<T> existing;
        long req_id = REQUEST_ID.getAndIncrement();
        req.requestId(req_id);
        hdr.requestId(req_id);
        if (log.isTraceEnabled()) {
            log.trace("%s: invoking %s RPC [req-id=%d]", this.local_addr, unicast ? "unicast" : "multicast", req_id);
        }
        if ((existing = this.requests.putIfAbsent(req_id, req)) == null) {
            req.viewChange(this.view, false);
            if (this.rpc_stats.extendedStats()) {
                req.start_time = System.nanoTime();
            }
        }
    }

    protected RequestCorrelator removeEntry(long req_id) {
        Request<?> req = this.requests.remove(req_id);
        if (req != null) {
            long time_ns;
            long l = time_ns = req.start_time > 0L ? System.nanoTime() - req.start_time : 0L;
            if (req instanceof UnicastRequest) {
                if (this.rpcstats) {
                    this.rpc_stats.add(RpcStats.Type.UNICAST, ((UnicastRequest)req).target, true, time_ns);
                }
            } else if (req instanceof GroupRequest) {
                if (this.rpcstats) {
                    if (req.options != null && req.options.anycasting()) {
                        this.rpc_stats.addAnycast(true, time_ns, ((GroupRequest)req).rsps.keySet());
                    } else {
                        this.rpc_stats.add(RpcStats.Type.MULTICAST, null, true, time_ns);
                    }
                }
            } else {
                log.error("request type %s not known", req != null ? req.getClass().getSimpleName() : req);
            }
        }
        return this;
    }

    protected void dispatch(Message msg, Header hdr) {
        switch (hdr.type) {
            case 0: {
                long start = this.rpcstats ? System.nanoTime() : 0L;
                this.handleRequest(msg, hdr);
                if (start <= 0L) break;
                long time = System.nanoTime() - start;
                this.avg_req_delivery.add(time);
                break;
            }
            case 1: 
            case 2: {
                long start = this.rpcstats ? System.nanoTime() : 0L;
                this.handleResponse(msg, hdr);
                if (start <= 0L) break;
                long time = System.nanoTime() - start;
                this.avg_rsp_delivery.add(time);
                break;
            }
            default: {
                log.error(Util.getMessage("HeaderSTypeIsNeitherREQNorRSP"));
            }
        }
    }

    protected void handleRequest(Message req, Header hdr) {
        Object retval;
        boolean threw_exception = false;
        if (log.isTraceEnabled()) {
            log.trace("calling (%s) with request %d", this.request_handler != null ? this.request_handler.getClass().getName() : "null", hdr.req_id);
        }
        if (this.async_dispatching && this.request_handler != null) {
            ResponseImpl rsp = hdr.rspExpected() ? new ResponseImpl(req, hdr.req_id) : null;
            try {
                this.request_handler.handle(req, rsp);
            }
            catch (Throwable t) {
                if (rsp != null) {
                    rsp.send(this.wrap_exceptions ? new InvocationTargetException(t) : t, true);
                }
                log.error("%s: failed dispatching request asynchronously: %s", this.local_addr, t);
            }
            return;
        }
        try {
            retval = this.request_handler.handle(req);
        }
        catch (Throwable t) {
            threw_exception = true;
            Object object = retval = this.wrap_exceptions ? new InvocationTargetException(t) : t;
        }
        if (hdr.rspExpected()) {
            this.sendReply(req, hdr.req_id, retval, threw_exception);
        }
    }

    protected void handleResponse(Message rsp, Header hdr) {
        Request<?> req = this.requests.get(hdr.req_id);
        if (req != null) {
            Object retval = rsp.getPayload();
            req.receiveResponse(retval, rsp.getSrc(), hdr.type == 2);
        }
    }

    protected void sendReply(Message req, long req_id, Object reply, boolean is_exception) {
        Message rsp = RequestCorrelator.makeReply(req).setFlag(req.getFlags(false), false, true).setPayload(reply).setFlag(Message.TransientFlag.DONT_BLOCK).clearFlag(Message.Flag.RSVP);
        this.sendResponse(rsp, req_id, is_exception);
    }

    protected static Message makeReply(Message msg) {
        Message reply = ((Message)msg.create().get()).setDest(msg.getSrc());
        if (msg.getDest() != null) {
            reply.setSrc(msg.getDest());
        }
        return reply;
    }

    protected void sendResponse(Message rsp, long req_id, boolean is_exception) {
        Header rsp_hdr = new Header(is_exception ? (byte)2 : 1, req_id, this.corr_id);
        rsp.putHeader(this.corr_id, rsp_hdr);
        if (log.isTraceEnabled()) {
            log.trace("sending rsp for %d to %s", req_id, rsp.getDest());
        }
        this.down_prot.down(rsp);
    }

    protected class MyProbeHandler
    implements DiagnosticsHandler.ProbeHandler {
        protected MyProbeHandler() {
        }

        @Override
        public Map<String, String> handleProbe(String ... keys) {
            if (RequestCorrelator.this.requests == null) {
                return null;
            }
            HashMap<String, String> retval = new HashMap<String, String>();
            String[] stringArray = keys;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "requests": {
                        StringBuilder sb = new StringBuilder();
                        for (Map.Entry<Long, Request<?>> entry : RequestCorrelator.this.requests.entrySet()) {
                            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
                        }
                        retval.put(key, sb.toString());
                        break;
                    }
                    case "reqtable-info": {
                        retval.put(key, String.format("size=%d, next-id=%d", RequestCorrelator.this.requests.size(), REQUEST_ID.get()));
                        break;
                    }
                    case "rpcs": {
                        if (!RequestCorrelator.this.rpcstats) {
                            retval.put(key, String.format("%s not enabled; use enable-rpcstats to enable it", key));
                            break;
                        }
                        retval.put("sync  unicast   RPCs", String.valueOf(RequestCorrelator.this.rpc_stats.unicasts(true)));
                        retval.put("sync  multicast RPCs", String.valueOf(RequestCorrelator.this.rpc_stats.multicasts(true)));
                        retval.put("async unicast   RPCs", String.valueOf(RequestCorrelator.this.rpc_stats.unicasts(false)));
                        retval.put("async multicast RPCs", String.valueOf(RequestCorrelator.this.rpc_stats.multicasts(false)));
                        retval.put("sync  anycast   RPCs", String.valueOf(RequestCorrelator.this.rpc_stats.anycasts(true)));
                        retval.put("async anycast   RPCs", String.valueOf(RequestCorrelator.this.rpc_stats.anycasts(false)));
                        break;
                    }
                    case "rpcs-reset": 
                    case "rtt-reset": {
                        RequestCorrelator.this.rpc_stats.reset();
                        break;
                    }
                    case "rpcs-enable-details": {
                        RequestCorrelator.this.rpc_stats.extendedStats(true);
                        RequestCorrelator.this.rpcstats = true;
                        break;
                    }
                    case "rpcs-disable-details": {
                        RequestCorrelator.this.rpc_stats.extendedStats(false);
                        break;
                    }
                    case "rpcs-details": {
                        if (!RequestCorrelator.this.rpc_stats.extendedStats()) {
                            retval.put(key, "<details not enabled: use rpcs-enable-details to enable>");
                            break;
                        }
                        retval.put(key, RequestCorrelator.this.rpc_stats.printStatsByDest());
                        break;
                    }
                    case "rtt": {
                        retval.put(key + " (min/avg/max)", RequestCorrelator.this.rpc_stats.printRTTStatsByDest());
                        break;
                    }
                    case "avg-req-delivery": {
                        if (!RequestCorrelator.this.rpcstats) {
                            retval.put(key, String.format("%s not enabled; use enable-rpcstats to enable it", key));
                            break;
                        }
                        retval.put(key, RequestCorrelator.this.avg_req_delivery.toString());
                        break;
                    }
                    case "avg-req-delivery-reset": {
                        RequestCorrelator.this.avg_req_delivery.clear();
                        break;
                    }
                    case "avg-rsp-delivery": {
                        if (!RequestCorrelator.this.rpcstats) {
                            retval.put(key, String.format("%s not enabled; use enable-rpcstats to enable it", key));
                            break;
                        }
                        retval.put(key, RequestCorrelator.this.avg_rsp_delivery.toString());
                        break;
                    }
                    case "avg-rsp-delivery-reset": {
                        RequestCorrelator.this.avg_rsp_delivery.clear();
                        break;
                    }
                    case "fjp": {
                        retval.put(key, RequestCorrelator.this.common_pool.toString());
                        break;
                    }
                    case "enable-rpcstats": {
                        RequestCorrelator.this.rpcstats = true;
                        break;
                    }
                    case "disable-rpcstats": {
                        RequestCorrelator.this.rpcstats = false;
                        break;
                    }
                    case "rpcstats": {
                        retval.put(key, String.format("rpcstats=%b (enable-rpcstats to enable), extended stats=%b (rpcs-enable-details to enable)", RequestCorrelator.this.rpcstats, RequestCorrelator.this.rpc_stats.extendedStats()));
                    }
                }
                if ("avg-req-delivery".startsWith(key)) {
                    retval.putIfAbsent("avg-req-delivery", RequestCorrelator.this.avg_req_delivery.toString());
                }
                if ("avg-rsp-delivery".startsWith(key)) {
                    retval.putIfAbsent("avg-rsp-delivery", RequestCorrelator.this.avg_rsp_delivery.toString());
                }
                if (!key.startsWith("async-rsp-handling")) continue;
                int index = key.indexOf(61);
                if (index < 0) {
                    retval.putIfAbsent("async-rsp-handling", String.valueOf(RequestCorrelator.this.async_rsp_handling));
                    continue;
                }
                RequestCorrelator.this.async_rsp_handling = Boolean.parseBoolean(key.substring(index + 1).trim());
            }
            return retval;
        }

        @Override
        public String[] supportedKeys() {
            return new String[]{"requests", "reqtable-info", "rpcs", "rpcs-reset", "rpcs-enable-details", "rpcs-disable-details", "rpcs-details", "rtt", "rtt-reset", "avg-req-delivery", "avg-req-delivery-reset", "async-rsp-handling", "avg-rsp-delivery", "avg-rsp-delivery-reset", "fjp", "enable-rpcstats", "disable-rpcstats", "stats"};
        }
    }

    public static final class MultiDestinationHeader
    extends Header {
        public Address[] exclusion_list;

        public MultiDestinationHeader() {
        }

        public MultiDestinationHeader(byte type, long id, short corr_id, Address[] exclusion_list) {
            super(type, id, corr_id);
            this.exclusion_list = exclusion_list;
        }

        @Override
        public short getMagicId() {
            return 68;
        }

        @Override
        public Supplier<? extends org.jgroups.Header> create() {
            return MultiDestinationHeader::new;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            super.writeTo(out);
            Util.writeAddresses(this.exclusion_list, out);
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            super.readFrom(in);
            this.exclusion_list = Util.readAddresses(in);
        }

        @Override
        public int serializedSize() {
            return (int)((long)super.serializedSize() + Util.size(this.exclusion_list));
        }

        @Override
        public String toString() {
            Object str = super.toString();
            if (this.exclusion_list != null) {
                str = (String)str + ", exclusion_list=" + Arrays.toString(this.exclusion_list);
            }
            return str;
        }
    }

    public static class Header
    extends org.jgroups.Header {
        public static final byte REQ = 0;
        public static final byte RSP = 1;
        public static final byte EXC_RSP = 2;
        public byte type;
        public long req_id;
        public short corrId;

        public Header() {
        }

        public Header(byte type, long req_id, short corr_id) {
            this.type = type;
            this.req_id = req_id;
            this.corrId = corr_id;
        }

        public Header requestId(long req_id) {
            if (this.req_id > 0L) {
                throw new IllegalStateException(String.format("request-id (%d) is already set: trying to set it again (%d)", this.req_id, req_id));
            }
            this.req_id = req_id;
            return this;
        }

        @Override
        public short getMagicId() {
            return 67;
        }

        @Override
        public Supplier<? extends org.jgroups.Header> create() {
            return Header::new;
        }

        public long requestId() {
            return this.req_id;
        }

        public boolean rspExpected() {
            return this.req_id > 0L;
        }

        public short corrId() {
            return this.corrId;
        }

        @Override
        public String toString() {
            StringBuilder ret = new StringBuilder();
            ret.append("corr_id=" + this.corrId + ", type=");
            switch (this.type) {
                case 0: {
                    ret.append("REQ");
                    break;
                }
                case 1: {
                    ret.append("RSP");
                    break;
                }
                case 2: {
                    ret.append("EXC_RSP");
                    break;
                }
                default: {
                    ret.append("<unknown>");
                }
            }
            ret.append(", req_id=" + this.req_id).append(", rsp_expected=" + this.rspExpected());
            return ret.toString();
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.writeByte(this.type);
            Bits.writeLongCompressed(this.req_id, out);
            out.writeShort(this.corrId);
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            this.req_id = Bits.readLongCompressed(in);
            this.corrId = in.readShort();
        }

        @Override
        public int serializedSize() {
            return 1 + Bits.size(this.req_id) + 2;
        }
    }

    protected class ResponseImpl
    implements Response {
        protected final Message req;
        protected final long req_id;

        public ResponseImpl(Message req, long req_id) {
            this.req = req;
            this.req_id = req_id;
        }

        @Override
        public void send(Object reply, boolean is_exception) {
            RequestCorrelator.this.sendReply(this.req, this.req_id, reply, is_exception);
        }

        @Override
        public void send(Message reply, boolean is_exception) {
            RequestCorrelator.this.sendResponse(reply, this.req_id, is_exception);
        }
    }
}

