/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.amqp;

import io.vertx.amqp.AmqpMessageBuilder;
import io.vertx.amqp.impl.AmqpMessageBuilderImpl;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.proton.message.Message;

@VertxGen
public interface AmqpMessage {
    public static AmqpMessageBuilder create() {
        return new AmqpMessageBuilderImpl();
    }

    public static AmqpMessageBuilder create(AmqpMessage existing) {
        return new AmqpMessageBuilderImpl(existing);
    }

    @GenIgnore
    public static AmqpMessageBuilder create(Message existing) {
        return new AmqpMessageBuilderImpl(existing);
    }

    public boolean isDurable();

    public boolean isFirstAcquirer();

    public int priority();

    public int deliveryCount();

    public long ttl();

    public String id();

    public String address();

    public String replyTo();

    public String correlationId();

    public boolean isBodyNull();

    public boolean bodyAsBoolean();

    public byte bodyAsByte();

    public short bodyAsShort();

    public int bodyAsInteger();

    public long bodyAsLong();

    public float bodyAsFloat();

    public double bodyAsDouble();

    public char bodyAsChar();

    @GenIgnore(value={"permitted-type"})
    public Instant bodyAsTimestamp();

    @GenIgnore(value={"permitted-type"})
    public UUID bodyAsUUID();

    public Buffer bodyAsBinary();

    public String bodyAsString();

    public String bodyAsSymbol();

    public <T> List<T> bodyAsList();

    @GenIgnore
    public <K, V> Map<K, V> bodyAsMap();

    public JsonObject bodyAsJsonObject();

    public JsonArray bodyAsJsonArray();

    public String subject();

    public String contentType();

    public String contentEncoding();

    public long expiryTime();

    public long creationTime();

    public String groupId();

    public String replyToGroupId();

    public long groupSequence();

    public JsonObject applicationProperties();

    @GenIgnore
    public Message unwrap();

    @Fluent
    public AmqpMessage accepted();

    @Fluent
    public AmqpMessage rejected();

    @Fluent
    public AmqpMessage released();

    @Fluent
    public AmqpMessage modified(boolean var1, boolean var2);
}

