/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import java.util.function.Function;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.jboss.as.clustering.infinispan.logging.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinitionRegistrar;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceRegistration;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResourceRegistration;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.subsystem.resource.ResourceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;

public class CustomStoreResourceDefinitionRegistrar<C extends StoreConfiguration, B extends StoreConfigurationBuilder<C, B>>
extends StoreResourceDefinitionRegistrar<C, B> {
    static final AttributeDefinition CLASS = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("class", ModelType.STRING).setAllowExpression(true)).setRequired(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();

    CustomStoreResourceDefinitionRegistrar() {
        super(new StoreResourceDefinitionRegistrar.Configurator<C, B>(){

            @Override
            public ResourceRegistration getResourceRegistration() {
                return StoreResourceRegistration.CUSTOM;
            }

            public ServiceDependency<B> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
                PathAddress cacheAddress = context.getCurrentAddress().getParent();
                PathAddress containerAddress = cacheAddress.getParent();
                BinaryServiceConfiguration configuration = BinaryServiceConfiguration.of((String)containerAddress.getLastElement().getValue(), (String)cacheAddress.getLastElement().getValue());
                final String className = CLASS.resolveModelAttribute(context, model).asString();
                return configuration.getServiceDependency(CacheResourceDefinitionRegistrar.CLASS_LOADER).map(new Function<ClassLoader, B>(){

                    @Override
                    public B apply(ClassLoader loader) {
                        try {
                            Class<?> storeClass = loader.loadClass(className);
                            return new ConfigurationBuilder().persistence().addStore(storeClass);
                        }
                        catch (ClassCastException | ClassNotFoundException e) {
                            throw InfinispanLogger.ROOT_LOGGER.invalidCacheStore(e, className);
                        }
                    }
                });
            }
        });
    }

    @Override
    public ResourceDescriptor.Builder apply(ResourceDescriptor.Builder builder) {
        return (ResourceDescriptor.Builder)super.apply(builder).addAttributes(List.of(CLASS));
    }
}

