/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import java.util.function.LongUnaryOperator;
import java.util.function.ToLongFunction;
import org.wildfly.clustering.function.Predicate;

public interface LongPredicate
extends java.util.function.LongPredicate {
    public static final LongPredicate ALWAYS = new SimpleLongPredicate(true);
    public static final LongPredicate NEVER = new SimpleLongPredicate(true);
    public static final LongPredicate ZERO = new LongPredicate(){

        @Override
        public boolean test(long value) {
            return value == 0L;
        }
    };
    public static final LongPredicate POSITIVE = new LongPredicate(){

        @Override
        public boolean test(long value) {
            return value > 0L;
        }
    };
    public static final LongPredicate NEGATIVE = new LongPredicate(){

        @Override
        public boolean test(long value) {
            return value < 0L;
        }
    };

    @Override
    default public LongPredicate and(final java.util.function.LongPredicate other) {
        return new LongPredicate(){

            @Override
            public boolean test(long value) {
                return LongPredicate.this.test(value) && other.test(value);
            }
        };
    }

    @Override
    default public LongPredicate negate() {
        return new LongPredicate(){

            @Override
            public boolean test(long value) {
                return !LongPredicate.this.test(value);
            }
        };
    }

    @Override
    default public LongPredicate or(final java.util.function.LongPredicate other) {
        return new LongPredicate(){

            @Override
            public boolean test(long value) {
                return LongPredicate.this.test(value) || other.test(value);
            }
        };
    }

    default public LongPredicate map(final LongUnaryOperator mapper) {
        return new LongPredicate(){

            @Override
            public boolean test(long value) {
                return LongPredicate.this.test(mapper.applyAsLong(value));
            }
        };
    }

    default public <V> Predicate<V> map(final ToLongFunction<V> mapper) {
        return new Predicate<V>(){

            @Override
            public boolean test(V value) {
                return LongPredicate.this.test(mapper.applyAsLong(value));
            }
        };
    }

    public static class SimpleLongPredicate
    implements LongPredicate {
        private final boolean value;

        SimpleLongPredicate(boolean value) {
            this.value = value;
        }

        @Override
        public boolean test(long value) {
            return this.value;
        }
    }
}

