/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.function;

import org.wildfly.clustering.function.BiPredicate;
import org.wildfly.clustering.function.Predicate;
import org.wildfly.clustering.function.Supplier;

public interface BooleanSupplier
extends java.util.function.BooleanSupplier {
    public static final BooleanSupplier TRUE = Boolean.TRUE::booleanValue;
    public static final BooleanSupplier FALSE = Boolean.FALSE::booleanValue;

    default public BooleanSupplier handle(final java.util.function.Predicate<RuntimeException> handler) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                try {
                    return BooleanSupplier.this.getAsBoolean();
                }
                catch (RuntimeException e) {
                    return handler.test(e);
                }
            }
        };
    }

    public static BooleanSupplier of(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static <T> BooleanSupplier of(final Predicate<T> predicate, final Supplier<T> supplier) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return predicate.test(supplier.get());
            }
        };
    }

    public static <T, U> BooleanSupplier of(final BiPredicate<T, U> predicate, final Supplier<T> formerSupplier, final Supplier<U> latterSupplier) {
        return new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return predicate.test(formerSupplier.get(), latterSupplier.get());
            }
        };
    }
}

