/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.cache.commons.util;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.module.ModuleCommandFactory;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.hibernate.cache.commons.util.BeginInvalidationCommand;
import org.infinispan.hibernate.cache.commons.util.EndInvalidationCommand;
import org.infinispan.hibernate.cache.commons.util.EvictAllCommand;
import org.infinispan.util.ByteString;

public class CacheCommandFactory
implements ModuleCommandFactory {
    public Map<Byte, Class<? extends ReplicableCommand>> getModuleCommands() {
        HashMap<Byte, Class<? extends ReplicableCommand>> map = new HashMap<Byte, Class<? extends ReplicableCommand>>(3);
        map.put((byte)120, EvictAllCommand.class);
        map.put((byte)121, EndInvalidationCommand.class);
        map.put((byte)122, BeginInvalidationCommand.class);
        return map;
    }

    public CacheRpcCommand fromStream(byte commandId, ByteString cacheName) {
        return switch (commandId) {
            case 120 -> new EvictAllCommand(cacheName);
            case 121 -> new EndInvalidationCommand(cacheName);
            default -> throw new IllegalArgumentException("Not registered to handle command id " + commandId);
        };
    }

    public ReplicableCommand fromStream(byte commandId) {
        if (commandId == 122) {
            return new BeginInvalidationCommand();
        }
        throw new IllegalArgumentException("Not registered to handle command id " + commandId);
    }
}

