/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.installationmanager.spi;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.wildfly.installationmanager.ArtifactChange;
import org.wildfly.installationmanager.CandidateType;
import org.wildfly.installationmanager.Channel;
import org.wildfly.installationmanager.FileConflict;
import org.wildfly.installationmanager.HistoryResult;
import org.wildfly.installationmanager.InstallationChanges;
import org.wildfly.installationmanager.ManifestVersion;
import org.wildfly.installationmanager.OperationNotAvailableException;
import org.wildfly.installationmanager.Repository;
import org.wildfly.installationmanager.spi.OsShell;

public interface InstallationManager {
    public List<HistoryResult> history() throws Exception;

    public InstallationChanges revisionDetails(String var1) throws Exception;

    public void prepareRevert(String var1, Path var2, List<Repository> var3) throws Exception;

    public boolean prepareUpdate(Path var1, List<Repository> var2) throws Exception;

    public List<ArtifactChange> findUpdates(List<Repository> var1) throws Exception;

    public Collection<Channel> listChannels() throws Exception;

    public void removeChannel(String var1) throws Exception;

    public void addChannel(Channel var1) throws Exception;

    public void changeChannel(Channel var1) throws Exception;

    public Path createSnapshot(Path var1) throws Exception;

    @Deprecated(forRemoval=true)
    public String generateApplyUpdateCommand(Path var1, Path var2) throws OperationNotAvailableException;

    @Deprecated(forRemoval=true)
    public String generateApplyRevertCommand(Path var1, Path var2) throws OperationNotAvailableException;

    @Deprecated(forRemoval=true)
    public String generateApplyUpdateCommand(Path var1, Path var2, OsShell var3) throws OperationNotAvailableException;

    @Deprecated(forRemoval=true)
    public String generateApplyRevertCommand(Path var1, Path var2, OsShell var3) throws OperationNotAvailableException;

    default public String generateApplyUpdateCommand(Path scriptHome, Path candidatePath, OsShell shell, boolean noConflictsOnly) throws OperationNotAvailableException {
        throw new UnsupportedOperationException("Method using noConflictsOnly argument is not implemented");
    }

    default public String generateApplyRevertCommand(Path scriptHome, Path candidatePath, OsShell shell, boolean noConflictsOnly) throws OperationNotAvailableException {
        throw new UnsupportedOperationException("Method using noConflictsOnly argument is not implemented");
    }

    public Collection<ManifestVersion> getInstalledVersions() throws Exception;

    default public Collection<FileConflict> verifyCandidate(Path candidatePath, CandidateType candidateType) throws Exception {
        throw new UnsupportedOperationException("Method verifyCandidate is not implemented");
    }
}

