/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.embedded;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.transaction.LockingMode;
import org.wildfly.clustering.cache.CacheProperties;
import org.wildfly.clustering.function.Supplier;

public class EmbeddedCacheProperties
implements CacheProperties {
    private final Supplier<Configuration> configurationProvider;
    private final Supplier<ComponentStatus> statusProvider;
    private final boolean lockOnRead;
    private final boolean lockOnWrite;
    private final boolean marshalling;
    private final boolean persistent;
    private final boolean transactional;

    public EmbeddedCacheProperties(Cache<?, ?> cache) {
        this((Supplier<Configuration>)((Supplier)() -> cache.getCacheConfiguration()), (Supplier<ComponentStatus>)((Supplier)() -> cache.getStatus()));
    }

    public EmbeddedCacheProperties(Configuration configuration) {
        this((Supplier<Configuration>)Supplier.of((Object)configuration), (Supplier<ComponentStatus>)Supplier.of((Object)ComponentStatus.RUNNING));
    }

    private EmbeddedCacheProperties(Supplier<Configuration> configurationProvider, Supplier<ComponentStatus> statusProvider) {
        this.configurationProvider = configurationProvider;
        this.statusProvider = statusProvider;
        Configuration configuration = (Configuration)configurationProvider.get();
        this.transactional = configuration.transaction().transactionMode().isTransactional();
        this.lockOnWrite = this.transactional && configuration.transaction().lockingMode() == LockingMode.PESSIMISTIC;
        this.lockOnRead = this.lockOnWrite && configuration.locking().lockIsolationLevel() == IsolationLevel.REPEATABLE_READ;
        boolean clustered = configuration.clustering().cacheMode().needsStateTransfer();
        boolean hasStore = configuration.persistence().usingStores();
        this.marshalling = clustered || hasStore;
        this.persistent = clustered || hasStore && !configuration.persistence().passivation() || configuration.memory().isOffHeap();
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public boolean isLockOnRead() {
        return this.lockOnRead;
    }

    public boolean isLockOnWrite() {
        return this.lockOnWrite;
    }

    public boolean isMarshalling() {
        return this.marshalling;
    }

    public boolean isActive() {
        ClusteringConfiguration clustering = ((Configuration)this.configurationProvider.get()).clustering();
        CacheMode mode = clustering.cacheMode();
        float capacityFactor = clustering.hash().capacityFactor();
        return ((ComponentStatus)this.statusProvider.get()).allowInvocations() && (!mode.isClustered() || capacityFactor > 0.0f && (!mode.isDistributed() || capacityFactor > Float.MIN_VALUE));
    }
}

