/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.micrometer.metrics;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.wildfly.common.Assert;
import org.wildfly.extension.micrometer.metrics.MetricID;
import org.wildfly.extension.micrometer.metrics.MetricMetadata;

public class WildFlyMetricMetadata
implements MetricMetadata {
    private static final Pattern SNAKE_CASE_PATTERN = Pattern.compile("(?<=[a-z])[A-Z]");
    private static final String STATISTICS = "statistics";
    private final String description;
    private final MeasurementUnit unit;
    private final MetricMetadata.Type type;
    private final String attributeName;
    private final PathAddress address;
    private String metricName;
    private MetricMetadata.MetricTag[] tags;
    private MetricID metricID;

    public WildFlyMetricMetadata(String attributeName, PathAddress address, String description, MeasurementUnit unit, MetricMetadata.Type type) {
        this.attributeName = (String)Assert.checkNotNullParamWithNullPointerException((String)"attributeName", (Object)attributeName);
        this.address = (PathAddress)Assert.checkNotNullParamWithNullPointerException((String)"address", (Object)address);
        this.description = (String)Assert.checkNotNullParamWithNullPointerException((String)"description", (Object)description);
        this.type = (MetricMetadata.Type)((Object)Assert.checkNotNullParamWithNullPointerException((String)"type", (Object)((Object)type)));
        this.unit = unit != null ? unit : MeasurementUnit.NONE;
        this.init();
    }

    private void init() {
        StringBuilder metricPrefix = new StringBuilder();
        ArrayList<String> labelNames = new ArrayList<String>();
        ArrayList<String> labelValues = new ArrayList<String>();
        for (PathElement element : this.address) {
            String key = element.getKey();
            String value = element.getValue();
            if (key.equals("subsystem") || key.equals(STATISTICS)) {
                metricPrefix.append(value).append("-");
                continue;
            }
            if (!key.equals("deployment") && !key.equals("subdeployment")) {
                labelNames.add("type");
                labelValues.add(key);
                labelNames.add("name");
                labelValues.add(value);
                continue;
            }
            labelNames.add(WildFlyMetricMetadata.getDottedName(key));
            labelValues.add(value);
        }
        int deploymentIndex = labelNames.indexOf("deployment");
        int subdeploymentIndex = labelNames.indexOf("subdeployment");
        if (deploymentIndex > -1 && subdeploymentIndex == -1) {
            labelNames.add("subdeployment");
            subdeploymentIndex = labelNames.size() - 1;
            labelValues.add((String)labelValues.get(deploymentIndex));
        }
        if (deploymentIndex == -1) {
            labelNames.add("deployment");
            labelValues.add("");
        }
        if (subdeploymentIndex == -1) {
            labelNames.add("subdeployment");
            labelValues.add("");
        }
        if (!labelNames.contains("app")) {
            labelNames.add("app");
            labelValues.add(deploymentIndex >= 0 ? (String)labelValues.get(deploymentIndex) : "wildfly");
        }
        this.metricName = WildFlyMetricMetadata.getDottedName(metricPrefix + this.attributeName);
        this.tags = new MetricMetadata.MetricTag[labelNames.size()];
        for (int i = 0; i < labelNames.size(); ++i) {
            this.tags[i] = new MetricMetadata.MetricTag((String)labelNames.get(i), (String)labelValues.get(i));
        }
        this.metricID = new MetricID(this.metricName, this.tags);
    }

    @Override
    public String getMetricName() {
        return this.metricName;
    }

    @Override
    public MetricMetadata.MetricTag[] getTags() {
        return this.tags;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public MeasurementUnit getMeasurementUnit() {
        return this.unit;
    }

    @Override
    public MetricMetadata.Type getType() {
        return this.type;
    }

    @Override
    public MetricID getMetricID() {
        return this.metricID;
    }

    private static String getDottedName(String name) {
        return WildFlyMetricMetadata.decamelize(name.replaceAll("[^\\w]+", "."));
    }

    private static String decamelize(String in) {
        Matcher m = SNAKE_CASE_PATTERN.matcher(in);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "." + m.group().toLowerCase(Locale.ENGLISH));
        }
        m.appendTail(sb);
        return sb.toString().toLowerCase(Locale.ENGLISH);
    }

    public String toString() {
        return ("WildFlyMetricMetadata{description='" + this.description + "', unit=" + this.unit + ", type=" + this.type + ", attributeName='" + this.attributeName + "', address=" + this.address + ", metricName='" + this.metricName + "', tags=" + Arrays.toString(this.tags) + ", metricID=" + this.metricID + "}").replaceAll("\\n", "");
    }
}

