/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.NetworkUtils;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.messaging.activemq.ActiveMQBroker;

class ConnectorService
implements Service {
    private final Supplier<ActiveMQBroker> serverSupplier;
    private final Supplier<SocketBinding> socketBindingSupplier;
    private final Supplier<OutboundSocketBinding> outboundSocketBindingSupplier;
    private final String factoryClass;
    private final Map<String, Object> parameters;
    private final Map<String, Object> extraParameters;
    private final String name;

    ConnectorService(Supplier<ActiveMQBroker> serverSupplier, Supplier<SocketBinding> socketBindingSupplier, Supplier<OutboundSocketBinding> outboundSocketBindingSupplier, String factoryClass, Map<String, Object> parameters, Map<String, Object> extraParameters, String name) {
        this.serverSupplier = serverSupplier;
        this.socketBindingSupplier = socketBindingSupplier;
        this.outboundSocketBindingSupplier = outboundSocketBindingSupplier;
        this.factoryClass = factoryClass;
        this.parameters = parameters;
        this.extraParameters = extraParameters;
        this.name = name;
    }

    public void start(StartContext sc) throws StartException {
        if (this.outboundSocketBindingSupplier != null) {
            binding = this.outboundSocketBindingSupplier.get();
            if (binding.getSourceAddress() != null) {
                this.parameters.put("localAddress", NetworkUtils.canonize((String)binding.getSourceAddress().getHostAddress()));
            }
            if (binding.getSourcePort() != null) {
                this.parameters.put("localPort", binding.getAbsoluteSourcePort());
            }
            this.parameters.put("host", NetworkUtils.canonize((String)binding.getUnresolvedDestinationAddress()));
            this.parameters.put("port", binding.getDestinationPort());
        } else if (this.socketBindingSupplier != null) {
            binding = this.socketBindingSupplier.get();
            if (binding.getClientMappings() != null && !binding.getClientMappings().isEmpty()) {
                ClientMapping clientMapping = (ClientMapping)binding.getClientMappings().get(0);
                this.parameters.put("host", NetworkUtils.canonize((String)clientMapping.getDestinationAddress()));
                this.parameters.put("port", clientMapping.getDestinationPort());
            } else {
                InetSocketAddress sa = binding.getSocketAddress();
                this.parameters.put("port", sa.getPort());
                if (sa.getAddress().isLoopbackAddress()) {
                    this.parameters.put("host", NetworkUtils.canonize((String)sa.getAddress().getHostName()));
                } else {
                    this.parameters.put("host", NetworkUtils.canonize((String)sa.getAddress().getHostAddress()));
                }
            }
        }
        try {
            this.serverSupplier.get().addConnectorConfiguration(this.name, new TransportConfiguration(this.factoryClass, this.parameters, this.name, this.extraParameters));
        }
        catch (Exception ex) {
            throw new StartException((Throwable)ex);
        }
    }

    public void stop(StopContext sc) {
    }
}

