/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.converter;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPStandardMessage;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageIdHelper;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageSupport;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.ConversionException;
import org.apache.activemq.artemis.protocol.amqp.converter.coreWrapper.CoreMessageWrapper;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPIllegalStateException;
import org.apache.activemq.artemis.protocol.amqp.util.TLSEncode;
import org.apache.activemq.artemis.reader.MessageUtil;
import org.apache.activemq.artemis.spi.core.protocol.EmbedMessageUtil;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.Properties;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.ReadableBuffer;

public class CoreAmqpConverter {
    public static AMQPMessage checkAMQP(Message message, StorageManager storageManager) throws Exception {
        if (message instanceof AMQPMessage) {
            AMQPMessage amqpMessage = (AMQPMessage)message;
            return amqpMessage;
        }
        return CoreAmqpConverter.fromCore(message.toCore(), storageManager);
    }

    public static AMQPMessage fromCore(ICoreMessage coreMessage, StorageManager storageManager) throws ConversionException {
        if (coreMessage == null) {
            return null;
        }
        try {
            long timeStamp;
            Object correlationID;
            long scheduledDelivery;
            SimpleString replyTo;
            SimpleString destination;
            String messageId;
            String type;
            byte priority;
            CoreMessageWrapper message;
            if (coreMessage.isServerMessage() && coreMessage.isLargeMessage() && coreMessage.getType() == 7 && (message = EmbedMessageUtil.extractEmbedded((ICoreMessage)coreMessage, (StorageManager)storageManager)) instanceof AMQPMessage) {
                AMQPMessage amqpMessage = (AMQPMessage)((Object)message);
                return amqpMessage;
            }
            message = CoreMessageWrapper.wrap(coreMessage);
            message.decode();
            Header header = null;
            Properties properties = new Properties();
            HashMap<Symbol, Object> daMap = null;
            HashMap<Symbol, Object> maMap = new HashMap<Symbol, Object>();
            HashMap<String, Object> apMap = null;
            HashMap<Symbol, Object> footerMap = null;
            Section body = message.createAMQPSection(maMap, properties);
            if (message.getInnerMessage().isDurable()) {
                if (header == null) {
                    header = new Header();
                }
                header.setDurable(Boolean.valueOf(true));
            }
            if ((priority = (byte)message.getJMSPriority()) != 4) {
                if (header == null) {
                    header = new Header();
                }
                header.setPriority(UnsignedByte.valueOf((byte)priority));
            }
            if ((type = message.getJMSType()) != null) {
                properties.setSubject(type);
            }
            if ((messageId = message.getJMSMessageID()) != null) {
                try {
                    properties.setMessageId(AMQPMessageIdHelper.INSTANCE.toIdObject(messageId));
                }
                catch (ActiveMQAMQPIllegalStateException e) {
                    properties.setMessageId((Object)messageId);
                }
            } else if (message.getInnerMessage().getUserID() != null) {
                properties.setMessageId((Object)("ID:" + message.getInnerMessage().getUserID().toString()));
            }
            if ((destination = message.getDestination()) != null) {
                properties.setTo(AMQPMessageSupport.toAddress(destination.toString()));
                maMap.put(AMQPMessageSupport.JMS_DEST_TYPE_MSG_ANNOTATION, AMQPMessageSupport.destinationType(destination.toString()));
            }
            if ((replyTo = message.getJMSReplyTo()) != null) {
                properties.setReplyTo(AMQPMessageSupport.toAddress(replyTo.toString()));
                maMap.put(AMQPMessageSupport.JMS_REPLY_TO_TYPE_MSG_ANNOTATION, AMQPMessageSupport.destinationType(replyTo.toString()));
            }
            if ((scheduledDelivery = coreMessage.getScheduledDeliveryTime().longValue()) > 0L) {
                maMap.put(AMQPMessageSupport.SCHEDULED_DELIVERY_TIME, scheduledDelivery);
            }
            if ((correlationID = message.getInnerMessage().getCorrelationID()) instanceof String || correlationID instanceof SimpleString) {
                String c = correlationID.toString();
                try {
                    properties.setCorrelationId(AMQPMessageIdHelper.INSTANCE.toIdObject(c));
                }
                catch (ActiveMQAMQPIllegalStateException e) {
                    properties.setCorrelationId(correlationID);
                }
            } else if (correlationID instanceof byte[]) {
                byte[] bytes = (byte[])correlationID;
                properties.setCorrelationId((Object)new Binary(bytes));
            } else {
                properties.setCorrelationId(correlationID);
            }
            long expiration = message.getExpiration();
            if (expiration != 0L) {
                long ttl = expiration - System.currentTimeMillis();
                if (ttl < 0L) {
                    ttl = 1L;
                }
                if (header == null) {
                    header = new Header();
                }
                header.setTtl(new UnsignedInteger((int)ttl));
                properties.setAbsoluteExpiryTime(new Date(expiration));
            }
            if ((timeStamp = message.getJMSTimestamp()) != 0L) {
                properties.setCreationTime(new Date(timeStamp));
            }
            Set keySet = MessageUtil.getPropertyNames((Message)message.getInnerMessage());
            for (String key : keySet) {
                Object objectProperty;
                if (key.startsWith("JMSX")) {
                    if (key.equals("JMSXUserID")) {
                        String value = message.getStringProperty(key);
                        if (value == null) continue;
                        properties.setUserId(Binary.create((ByteBuffer)StandardCharsets.UTF_8.encode(value)));
                        continue;
                    }
                    if (key.equals("JMSXGroupID")) {
                        String value = message.getStringProperty(key);
                        properties.setGroupId(value);
                        continue;
                    }
                    if (key.equals("JMSXGroupSeq")) {
                        int value = message.getIntProperty(key);
                        properties.setGroupSequence(UnsignedInteger.valueOf((int)value));
                        continue;
                    }
                } else if (key.startsWith("JMS_AMQP_")) {
                    if (key.equals("JMS_AMQP_NATIVE")) continue;
                    if (key.equals("JMS_AMQP_FirstAcquirer")) {
                        if (header == null) {
                            header = new Header();
                        }
                        header.setFirstAcquirer(Boolean.valueOf(message.getBooleanProperty(key)));
                        continue;
                    }
                    if (key.equals("JMS_AMQP_HEADER")) {
                        if (header != null) continue;
                        header = new Header();
                        continue;
                    }
                    if (key.equals("JMS_AMQP_HEADERDURABLE")) {
                        if (header == null) {
                            header = new Header();
                        }
                        header.setDurable(Boolean.valueOf(message.getInnerMessage().isDurable()));
                        continue;
                    }
                    if (key.equals("JMS_AMQP_HEADERPRIORITY")) {
                        if (header == null) {
                            header = new Header();
                        }
                        header.setPriority(UnsignedByte.valueOf((byte)priority));
                        continue;
                    }
                    if (key.startsWith("JMS_AMQP_PROPERTIES")) continue;
                    if (key.startsWith("JMS_AMQP_DA_")) {
                        if (daMap == null) {
                            daMap = new HashMap<Symbol, Object>();
                        }
                        String name = key.substring("JMS_AMQP_DA_".length());
                        daMap.put(Symbol.valueOf((String)name), message.getObjectProperty(key));
                        continue;
                    }
                    if (key.startsWith("JMS_AMQP_ENCODED_DA_")) {
                        if (daMap == null) {
                            daMap = new HashMap();
                        }
                        String name = key.substring("JMS_AMQP_ENCODED_DA_".length());
                        daMap.put(Symbol.valueOf((String)name), CoreAmqpConverter.decodeEmbeddedAMQPType(message.getObjectProperty(key)));
                        continue;
                    }
                    if (key.startsWith("JMS_AMQP_MA_")) {
                        String name = key.substring("JMS_AMQP_MA_".length());
                        maMap.put(Symbol.valueOf((String)name), message.getObjectProperty(key));
                        continue;
                    }
                    if (key.startsWith("JMS_AMQP_ENCODED_MA_")) {
                        String name = key.substring("JMS_AMQP_ENCODED_MA_".length());
                        maMap.put(Symbol.valueOf((String)name), CoreAmqpConverter.decodeEmbeddedAMQPType(message.getObjectProperty(key)));
                        continue;
                    }
                    if (key.equals("JMS_AMQP_ContentType")) {
                        properties.setContentType(Symbol.getSymbol((String)message.getStringProperty(key)));
                        continue;
                    }
                    if (key.equals("JMS_AMQP_ContentEncoding")) {
                        properties.setContentEncoding(Symbol.getSymbol((String)message.getStringProperty(key)));
                        continue;
                    }
                    if (key.equals("JMS_AMQP_ReplyToGroupID")) {
                        properties.setReplyToGroupId(message.getStringProperty(key));
                        continue;
                    }
                    if (key.equals("JMS_AMQP_ORIGINAL_ENCODING")) continue;
                    if (key.startsWith("JMS_AMQP_ENCODED_FT_")) {
                        if (footerMap == null) {
                            footerMap = new HashMap<Symbol, Object>();
                        }
                        String name = key.substring("JMS_AMQP_ENCODED_FT_".length());
                        footerMap.put(Symbol.valueOf((String)name), CoreAmqpConverter.decodeEmbeddedAMQPType(message.getObjectProperty(key)));
                        continue;
                    }
                    if (key.startsWith("JMS_AMQP_FT_")) {
                        if (footerMap == null) {
                            footerMap = new HashMap();
                        }
                        String name = key.substring("JMS_AMQP_FT_".length());
                        footerMap.put(Symbol.valueOf((String)name), message.getObjectProperty(key));
                        continue;
                    }
                } else {
                    if (key.equals(Message.HDR_GROUP_ID.toString())) {
                        String value = message.getStringProperty(key);
                        properties.setGroupId(value);
                        continue;
                    }
                    if (key.equals(Message.HDR_GROUP_SEQUENCE.toString())) {
                        int value = message.getIntProperty(key);
                        properties.setGroupSequence(UnsignedInteger.valueOf((int)value));
                        continue;
                    }
                    if (key.equals("NATIVE_MESSAGE_ID") || key.endsWith(Message.HDR_SCHEDULED_DELIVERY_TIME.toString())) continue;
                    if (key.equals(Message.HDR_INGRESS_TIMESTAMP.toString())) {
                        maMap.put(AMQPMessageSupport.INGRESS_TIME_MSG_ANNOTATION, message.getLongProperty(key));
                        continue;
                    }
                }
                if (apMap == null) {
                    apMap = new HashMap<String, Object>();
                }
                if ((objectProperty = message.getObjectProperty(key)) instanceof byte[]) {
                    byte[] bytes = (byte[])objectProperty;
                    objectProperty = new Binary(bytes);
                }
                apMap.put(key, objectProperty);
            }
            long messageID = message.getInnerMessage().getMessageID();
            return AMQPStandardMessage.createMessage(messageID, 0L, replyTo, header, properties, daMap, maMap, apMap, footerMap, body);
        }
        catch (ConversionException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new ConversionException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object decodeEmbeddedAMQPType(Object payload) {
        byte[] encodedType = (byte[])payload;
        DecoderImpl decoder = TLSEncode.getDecoder();
        Object decodedType = null;
        decoder.setBuffer((ReadableBuffer)ReadableBuffer.ByteBufferReader.wrap((byte[])encodedType));
        try {
            decodedType = decoder.readObject();
        }
        finally {
            decoder.setBuffer(null);
        }
        return decodedType;
    }
}

