/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederationAddressPolicyElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederationQueuePolicyElement;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPStandardMessage;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConstants;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromAddressPolicy;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromQueuePolicy;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.util.NettyWritable;
import org.apache.activemq.artemis.protocol.amqp.util.TLSEncode;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.WritableBuffer;

public final class AMQPFederationPolicySupport {
    public static final int DEFAULT_QUEUE_RECEIVER_PRIORITY_ADJUSTMENT = -1;
    public static final Symbol MESSAGE_HOPS_ANNOTATION = Symbol.valueOf((String)"x-opt-amq-fed-hops");
    public static final String MESSAGE_HOPS_PROPERTY = "_AMQ_Fed_Hops";
    public static final Symbol FEDERATED_ADDRESS_SOURCE_PROPERTIES = Symbol.valueOf((String)"federated-address-source-properties");

    public static String generateAddressFilter(int maxHops) {
        if (maxHops <= 0) {
            return null;
        }
        return "(\"m." + String.valueOf(MESSAGE_HOPS_ANNOTATION) + "\" IS NULL OR \"m." + String.valueOf(MESSAGE_HOPS_ANNOTATION) + "\"<" + maxHops + ") AND (_AMQ_Fed_Hops IS NULL OR _AMQ_Fed_Hops<" + maxHops + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AMQPMessage encodeQueuePolicyControlMessage(FederationReceiveFromQueuePolicy policy) {
        LinkedHashMap<Symbol, String> annotations = new LinkedHashMap<Symbol, String>();
        MessageAnnotations messageAnnotations = new MessageAnnotations(annotations);
        LinkedHashMap<String, Object> policyMap = new LinkedHashMap<String, Object>();
        AmqpValue sectionBody = new AmqpValue(policyMap);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.heapBuffer(1024);
        annotations.put(AMQPFederationConstants.OPERATION_TYPE, "ADD_QUEUE_POLICY");
        policyMap.put("policy-name", policy.getPolicyName());
        policyMap.put("include-federated", policy.isIncludeFederated());
        policyMap.put("priority-adjustment", policy.getPriorityAjustment());
        if (!policy.getIncludes().isEmpty()) {
            ArrayList flattenedIncludes = new ArrayList(policy.getIncludes().size() * 2);
            policy.getIncludes().forEach(entry -> {
                flattenedIncludes.add((String)entry.getKey());
                flattenedIncludes.add((String)entry.getValue());
            });
            policyMap.put("queue-includes", flattenedIncludes);
        }
        if (!policy.getExcludes().isEmpty()) {
            ArrayList flatteneExcludes = new ArrayList(policy.getExcludes().size() * 2);
            policy.getExcludes().forEach(entry -> {
                flatteneExcludes.add((String)entry.getKey());
                flatteneExcludes.add((String)entry.getValue());
            });
            policyMap.put("queue-excludes", flatteneExcludes);
        }
        if (!policy.getProperties().isEmpty()) {
            policyMap.put("policy-properties-map", policy.getProperties());
        }
        if (policy.getTransformerConfiguration() != null) {
            TransformerConfiguration config = policy.getTransformerConfiguration();
            policyMap.put("transformer-class-name", config.getClassName());
            if (!config.getProperties().isEmpty()) {
                policyMap.put("transformer-properties-map", config.getProperties());
            }
        }
        try {
            EncoderImpl encoder = TLSEncode.getEncoder();
            encoder.setByteBuffer((WritableBuffer)new NettyWritable(buffer));
            encoder.writeObject((Object)messageAnnotations);
            encoder.writeObject((Object)sectionBody);
            byte[] data = new byte[buffer.writerIndex()];
            buffer.readBytes(data);
            AMQPStandardMessage aMQPStandardMessage = new AMQPStandardMessage(0L, data, null);
            return aMQPStandardMessage;
        }
        finally {
            TLSEncode.getEncoder().setByteBuffer((WritableBuffer)null);
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AMQPMessage encodeAddressPolicyControlMessage(FederationReceiveFromAddressPolicy policy) {
        LinkedHashMap<Symbol, String> annotations = new LinkedHashMap<Symbol, String>();
        MessageAnnotations messageAnnotations = new MessageAnnotations(annotations);
        LinkedHashMap<String, Object> policyMap = new LinkedHashMap<String, Object>();
        AmqpValue sectionBody = new AmqpValue(policyMap);
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.heapBuffer(1024);
        annotations.put(AMQPFederationConstants.OPERATION_TYPE, "ADD_ADDRESS_POLICY");
        policyMap.put("policy-name", policy.getPolicyName());
        policyMap.put("auto-delete", policy.isAutoDelete());
        policyMap.put("auto-delete-delay", policy.getAutoDeleteDelay());
        policyMap.put("auto-delete-msg-count", policy.getAutoDeleteMessageCount());
        policyMap.put("max-hops", policy.getMaxHops());
        policyMap.put("enable-divert-bindings", policy.isEnableDivertBindings());
        if (!policy.getIncludes().isEmpty()) {
            policyMap.put("address-includes", new ArrayList<String>(policy.getIncludes()));
        }
        if (!policy.getExcludes().isEmpty()) {
            policyMap.put("address-excludes", new ArrayList<String>(policy.getExcludes()));
        }
        if (!policy.getProperties().isEmpty()) {
            policyMap.put("policy-properties-map", policy.getProperties());
        }
        if (policy.getTransformerConfiguration() != null) {
            TransformerConfiguration config = policy.getTransformerConfiguration();
            policyMap.put("transformer-class-name", config.getClassName());
            if (!config.getProperties().isEmpty()) {
                policyMap.put("transformer-properties-map", config.getProperties());
            }
        }
        try {
            EncoderImpl encoder = TLSEncode.getEncoder();
            encoder.setByteBuffer((WritableBuffer)new NettyWritable(buffer));
            encoder.writeObject((Object)messageAnnotations);
            encoder.writeObject((Object)sectionBody);
            byte[] data = new byte[buffer.writerIndex()];
            buffer.readBytes(data);
            AMQPStandardMessage aMQPStandardMessage = new AMQPStandardMessage(0L, data, null);
            return aMQPStandardMessage;
        }
        finally {
            TLSEncode.getEncoder().setByteBuffer((WritableBuffer)null);
            buffer.release();
        }
    }

    public static FederationReceiveFromQueuePolicy decodeReceiveFromQueuePolicy(AMQPMessage message, WildcardConfiguration wildcardConfig) throws ActiveMQException {
        Section body = message.getBody();
        if (!(body instanceof AmqpValue)) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.malformedFederationControlMessage("Message body was not an AmqpValue type");
        }
        AmqpValue bodyValue = (AmqpValue)body;
        if (bodyValue.getValue() == null || !(bodyValue.getValue() instanceof Map)) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.malformedFederationControlMessage("Message body AmqpValue did not carry an encoded Map");
        }
        try {
            TransformerConfiguration transformerConfig;
            Map policyMap = (Map)bodyValue.getValue();
            if (!policyMap.containsKey("policy-name")) {
                throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.malformedFederationControlMessage("Message body did not carry the required policy name");
            }
            String policyName = (String)policyMap.get("policy-name");
            boolean includeFederated = policyMap.getOrDefault("include-federated", false);
            int priorityAdjustment = ((Number)policyMap.getOrDefault("priority-adjustment", -1)).intValue();
            Set<Map.Entry<String, String>> includes = AMQPFederationPolicySupport.decodeFlattenedFilterSet(policyMap, "queue-includes");
            Set<Map.Entry<String, String>> excludes = AMQPFederationPolicySupport.decodeFlattenedFilterSet(policyMap, "queue-excludes");
            if (policyMap.containsKey("transformer-class-name")) {
                transformerConfig = new TransformerConfiguration();
                transformerConfig.setClassName((String)policyMap.get("transformer-class-name"));
                transformerConfig.setProperties((Map)policyMap.get("transformer-properties-map"));
            } else {
                transformerConfig = null;
            }
            Map properties = policyMap.containsKey("policy-properties-map") ? (Map)policyMap.get("policy-properties-map") : null;
            return new FederationReceiveFromQueuePolicy(policyName, includeFederated, priorityAdjustment, includes, excludes, properties, transformerConfig, wildcardConfig);
        }
        catch (ActiveMQException amqEx) {
            throw amqEx;
        }
        catch (Exception e) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.malformedFederationControlMessage("Invalid encoded queue policy entry: " + e.getMessage());
        }
    }

    private static Set<Map.Entry<String, String>> decodeFlattenedFilterSet(Map<String, Object> policyMap, String target) throws ActiveMQException {
        HashSet<Map.Entry<String, String>> policyEntrySet;
        Object encodedObject = policyMap.get(target);
        if (encodedObject == null) {
            return Collections.emptySet();
        }
        if (!(encodedObject instanceof List)) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.malformedFederationControlMessage("Encoded queue policy entry was not the expected List type : " + target);
        }
        try {
            List flattenedEntrySet = (List)encodedObject;
            if (flattenedEntrySet.isEmpty()) {
                return Collections.emptySet();
            }
            if ((flattenedEntrySet.size() & 1) != 0) {
                throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.malformedFederationControlMessage("Encoded queue policy entry was must contain an even number of elements : " + target);
            }
            policyEntrySet = new HashSet<Map.Entry<String, String>>(Math.max(2, flattenedEntrySet.size() / 2));
            int i = 0;
            while (i < flattenedEntrySet.size()) {
                policyEntrySet.add(new AbstractMap.SimpleEntry<String, String>((String)flattenedEntrySet.get(i++), (String)flattenedEntrySet.get(i++)));
            }
        }
        catch (ActiveMQException amqEx) {
            throw amqEx;
        }
        catch (Exception e) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.malformedFederationControlMessage("Invalid encoded queue policy entry: " + e.getMessage());
        }
        return policyEntrySet;
    }

    public static FederationReceiveFromAddressPolicy decodeReceiveFromAddressPolicy(AMQPMessage message, WildcardConfiguration wildcardConfig) throws ActiveMQException {
        Section body = message.getBody();
        if (!(body instanceof AmqpValue)) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.malformedFederationControlMessage("Message body was not an AmqpValue type");
        }
        AmqpValue bodyValue = (AmqpValue)body;
        if (bodyValue.getValue() == null || !(bodyValue.getValue() instanceof Map)) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.malformedFederationControlMessage("Message body AmqpValue did not carry an encoded Map");
        }
        try {
            TransformerConfiguration transformerConfig;
            Map policyMap = (Map)bodyValue.getValue();
            if (!policyMap.containsKey("policy-name")) {
                throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.malformedFederationControlMessage("Message body did not carry the required policy name");
            }
            if (!policyMap.containsKey("max-hops")) {
                throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.malformedFederationControlMessage("Message body did not carry the required max hops configuration");
            }
            String policyName = (String)policyMap.get("policy-name");
            boolean autoDelete = policyMap.getOrDefault("auto-delete", false);
            long autoDeleteDelay = ((Number)policyMap.getOrDefault("auto-delete-delay", 0L)).longValue();
            long autoDeleteMsgCount = ((Number)policyMap.getOrDefault("auto-delete-msg-count", 0L)).longValue();
            int maxHops = ((Number)policyMap.get("max-hops")).intValue();
            boolean enableDiverts = policyMap.getOrDefault("enable-divert-bindings", false);
            Set<String> includes = policyMap.containsKey("address-includes") ? new HashSet((List)policyMap.get("address-includes")) : Collections.emptySet();
            Set<String> excludes = policyMap.containsKey("address-excludes") ? new HashSet((List)policyMap.get("address-excludes")) : Collections.emptySet();
            if (policyMap.containsKey("transformer-class-name")) {
                transformerConfig = new TransformerConfiguration();
                transformerConfig.setClassName((String)policyMap.get("transformer-class-name"));
                transformerConfig.setProperties((Map)policyMap.get("transformer-properties-map"));
            } else {
                transformerConfig = null;
            }
            Map properties = policyMap.containsKey("policy-properties-map") ? (Map)policyMap.get("policy-properties-map") : null;
            return new FederationReceiveFromAddressPolicy(policyName, autoDelete, autoDeleteDelay, autoDeleteMsgCount, maxHops, enableDiverts, includes, excludes, properties, transformerConfig, wildcardConfig);
        }
        catch (Exception e) {
            throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.malformedFederationControlMessage("Invalid encoded address policy entry: " + e.getMessage());
        }
    }

    public static FederationReceiveFromAddressPolicy create(AMQPFederationAddressPolicyElement element, WildcardConfiguration wildcards) {
        Set<String> excludes;
        Set<String> includes;
        if (element.getIncludes() != null && !element.getIncludes().isEmpty()) {
            includes = new HashSet(element.getIncludes().size());
            element.getIncludes().forEach(addressMatch -> includes.add(addressMatch.getAddressMatch()));
        } else {
            includes = Collections.emptySet();
        }
        if (element.getExcludes() != null && !element.getExcludes().isEmpty()) {
            excludes = new HashSet(element.getExcludes().size());
            element.getExcludes().forEach(addressMatch -> excludes.add(addressMatch.getAddressMatch()));
        } else {
            excludes = Collections.emptySet();
        }
        FederationReceiveFromAddressPolicy policy = new FederationReceiveFromAddressPolicy(element.getName(), element.getAutoDelete() == null ? false : element.getAutoDelete(), element.getAutoDeleteDelay() == null ? 0L : element.getAutoDeleteDelay(), element.getAutoDeleteMessageCount() == null ? 0L : element.getAutoDeleteMessageCount(), element.getMaxHops(), element.isEnableDivertBindings() == null ? false : element.isEnableDivertBindings(), includes, excludes, element.getProperties(), element.getTransformerConfiguration(), wildcards);
        return policy;
    }

    public static FederationReceiveFromQueuePolicy create(AMQPFederationQueuePolicyElement element, WildcardConfiguration wildcards) {
        Set<Map.Entry<String, String>> excludes;
        Set<Map.Entry<String, String>> includes;
        if (element.getIncludes() != null && !element.getIncludes().isEmpty()) {
            includes = new HashSet(element.getIncludes().size());
            element.getIncludes().forEach(queueMatch -> includes.add(new AbstractMap.SimpleImmutableEntry<String, String>(queueMatch.getAddressMatch(), queueMatch.getQueueMatch())));
        } else {
            includes = Collections.emptySet();
        }
        if (element.getExcludes() != null && !element.getExcludes().isEmpty()) {
            excludes = new HashSet(element.getExcludes().size());
            element.getExcludes().forEach(queueMatch -> excludes.add(new AbstractMap.SimpleImmutableEntry<String, String>(queueMatch.getAddressMatch(), queueMatch.getQueueMatch())));
        } else {
            excludes = Collections.emptySet();
        }
        FederationReceiveFromQueuePolicy policy = new FederationReceiveFromQueuePolicy(element.getName(), element.isIncludeFederated(), element.getPriorityAdjustment() == null ? -1 : element.getPriorityAdjustment(), includes, excludes, element.getProperties(), element.getTransformerConfiguration(), wildcards);
        return policy;
    }
}

