/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.settings.impl.Match;
import org.apache.activemq.artemis.protocol.amqp.connect.bridge.AMQPBridgePolicy;
import org.apache.qpid.proton.amqp.Symbol;

public final class AMQPBridgeQueuePolicy
extends AMQPBridgePolicy
implements BiPredicate<String, String> {
    private final Set<QueueMatcher> includeMatchers = new LinkedHashSet<QueueMatcher>();
    private final Set<QueueMatcher> excludeMatchers = new LinkedHashSet<QueueMatcher>();
    private final Collection<Map.Entry<String, String>> includes;
    private final Collection<Map.Entry<String, String>> excludes;
    private final int priorityAdjustment;

    public AMQPBridgeQueuePolicy(String policyName, Integer priority, int priorityAdjustment, String filter, String remoteAddress, String remoteAddressPrefix, String remoteAddressSuffix, Collection<Symbol> remoteTerminusCapabilities, Collection<Map.Entry<String, String>> includeQueues, Collection<Map.Entry<String, String>> excludeQueues, Map<String, Object> properties, TransformerConfiguration transformerConfig, WildcardConfiguration wildcardConfig) {
        super(policyName, priority, filter, remoteAddress, remoteAddressPrefix, remoteAddressSuffix, remoteTerminusCapabilities, properties, transformerConfig, wildcardConfig);
        this.priorityAdjustment = priorityAdjustment;
        this.includes = Collections.unmodifiableCollection(includeQueues == null ? Collections.emptyList() : includeQueues);
        this.excludes = Collections.unmodifiableCollection(excludeQueues == null ? Collections.emptyList() : excludeQueues);
        this.includes.forEach(entry -> this.includeMatchers.add(new QueueMatcher((String)entry.getKey(), (String)entry.getValue(), wildcardConfig)));
        this.excludes.forEach(entry -> this.excludeMatchers.add(new QueueMatcher((String)entry.getKey(), (String)entry.getValue(), wildcardConfig)));
    }

    public Collection<Map.Entry<String, String>> getIncludes() {
        return this.includes;
    }

    public Collection<Map.Entry<String, String>> getExcludes() {
        return this.excludes;
    }

    public int getPriorityAdjustment() {
        return this.priorityAdjustment;
    }

    public boolean testQueue(String queue) {
        for (QueueMatcher matcher : this.excludeMatchers) {
            if (!matcher.testQueue(queue)) continue;
            return false;
        }
        for (QueueMatcher matcher : this.includeMatchers) {
            if (!matcher.testQueue(queue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean test(String address, String queue) {
        for (QueueMatcher matcher : this.excludeMatchers) {
            if (!matcher.test(address, queue)) continue;
            return false;
        }
        for (QueueMatcher matcher : this.includeMatchers) {
            if (!matcher.test(address, queue)) continue;
            return true;
        }
        return false;
    }

    private class QueueMatcher
    implements BiPredicate<String, String> {
        private final Predicate<String> addressMatch;
        private final Predicate<String> queueMatch;

        QueueMatcher(String address, String queue, WildcardConfiguration wildcardConfig) {
            this.addressMatch = address == null || address.isEmpty() ? target -> true : new Match(address, null, wildcardConfig).getPattern().asPredicate();
            this.queueMatch = queue == null || queue.isEmpty() ? target -> true : new Match(queue, null, wildcardConfig).getPattern().asPredicate();
        }

        @Override
        public boolean test(String address, String queue) {
            return this.testAddress(address) && this.testQueue(queue);
        }

        public boolean testAddress(String address) {
            return this.addressMatch.test(address);
        }

        public boolean testQueue(String queue) {
            return this.queueMatch.test(queue);
        }
    }
}

