/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.converters;

import io.smallrye.reactive.messaging.kafka.api.IncomingKafkaRecordMetadata;
import io.smallrye.reactive.messaging.keyed.KeyValueExtractor;
import io.smallrye.reactive.messaging.providers.helpers.TypeUtils;
import jakarta.enterprise.context.ApplicationScoped;
import java.lang.reflect.Type;
import java.util.Optional;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class KeyValueFromKafkaRecordExtractor
implements KeyValueExtractor {
    public boolean canExtract(Message<?> message, Type keyType, Type valueType) {
        Optional metadata = message.getMetadata(IncomingKafkaRecordMetadata.class);
        return metadata.filter(incomingKafkaRecordMetadata -> TypeUtils.isAssignable((Type)keyType, incomingKafkaRecordMetadata.getKey().getClass()) && TypeUtils.isAssignable((Type)valueType, incomingKafkaRecordMetadata.getRecord().value().getClass())).isPresent();
    }

    public Object extractKey(Message<?> message, Type keyType) {
        return message.getMetadata(IncomingKafkaRecordMetadata.class).map(IncomingKafkaRecordMetadata::getKey).orElseThrow();
    }

    public Object extractValue(Message<?> message, Type valueType) {
        return message.getPayload();
    }
}

