/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.sort.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.AbstractElasticsearchSort;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSort;
import org.hibernate.search.backend.elasticsearch.search.sort.impl.ElasticsearchSearchSortCollector;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.spi.CompositeSortBuilder;

public class ElasticsearchCompositeSort
extends AbstractElasticsearchSort {
    private final List<ElasticsearchSearchSort> elements;

    protected ElasticsearchCompositeSort(Builder builder) {
        super(builder);
        this.elements = builder.elements;
        builder.elements = null;
    }

    @Override
    public void toJsonSorts(ElasticsearchSearchSortCollector collector) {
        for (ElasticsearchSearchSort element : this.elements) {
            element.toJsonSorts(collector);
        }
    }

    public static class Builder
    extends AbstractElasticsearchSort.AbstractBuilder
    implements CompositeSortBuilder {
        private List<ElasticsearchSearchSort> elements = new ArrayList<ElasticsearchSearchSort>();

        protected Builder(ElasticsearchSearchIndexScope<?> scope) {
            super(scope);
        }

        public void add(SearchSort sort) {
            this.elements.add(ElasticsearchSearchSort.from(this.scope, sort));
        }

        public SearchSort build() {
            return new ElasticsearchCompositeSort(this);
        }
    }
}

