/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.gson.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.gson.impl.AbstractTypingJsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonCompositeAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementType;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.ObjectPropertyJsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.UnknownTypeJsonAccessor;
import org.hibernate.search.util.common.impl.Contracts;

public class JsonObjectAccessorImpl
extends AbstractTypingJsonAccessor<JsonObject>
implements JsonObjectAccessor,
JsonCompositeAccessor<JsonObject> {
    public JsonObjectAccessorImpl(JsonAccessor<JsonElement> parent) {
        super(parent);
    }

    @Override
    protected JsonElementType<JsonObject> getExpectedElementType() {
        return JsonElementTypes.OBJECT;
    }

    @Override
    public JsonObject getOrCreate(JsonObject root) {
        return (JsonObject)this.getOrCreate(root, JsonObject::new);
    }

    @Override
    public UnknownTypeJsonAccessor property(String propertyName) {
        Contracts.assertNotNullNorEmpty((String)propertyName, (String)"propertyName");
        return new ObjectPropertyJsonAccessor(this, propertyName);
    }
}

