/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jts;

import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.internal.jts.orbspecific.TransactionFactoryImple;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.common.util.ConfigurationInfo;
import com.arjuna.orbportability.OA;
import com.arjuna.orbportability.ORB;
import com.arjuna.orbportability.RootOA;
import com.arjuna.orbportability.Services;
import org.omg.CosTransactions.TransactionFactory;

public class TransactionServer {
    public static final void registerTransactionManager(int resolver, ORB myORB, TransactionFactory theOTS) throws Exception {
        Services myServ = new Services(myORB);
        if (resolver != 5) {
            Object[] params = new String[]{"OTS"};
            myServ.registerService(theOTS, "TransactionManagerService", params, resolver);
            params = null;
        }
    }

    public static void main(String[] args) {
        try {
            TransactionServer.doWork(args);
        }
        catch (Exception ex) {
            jtsLogger.i18NLogger.warn_caughtexception(ex);
        }
    }

    static void doWork(String[] args) throws Exception {
        TransactionServer.doWork(args, false);
    }

    static void doWork(String[] args, boolean exitOnComplete) throws Exception {
        String refFile = "TransactionManagerService";
        String objectName = null;
        boolean printReady = false;
        ORB myORB = null;
        RootOA myOA = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].compareTo("-otsname") == 0) {
                objectName = args[i + 1];
            }
            if (args[i].compareTo("-test") == 0) {
                printReady = true;
            }
            if (args[i].compareTo("-help") == 0) {
                System.out.println("Usage: [-otsname <name>] [-help] [-version] [-recovery]");
                if (exitOnComplete) {
                    return;
                }
                System.exit(0);
            }
            if (args[i].compareTo("-version") == 0) {
                System.out.println("TransactionServer version " + ConfigurationInfo.getVersion());
                if (exitOnComplete) {
                    return;
                }
                System.exit(0);
            }
            if (args[i].compareTo("-recovery") != 0) continue;
            RecoveryManager.manager().startRecoveryManagerThread();
        }
        TransactionFactoryImple theOTS = null;
        int resolver = Services.getResolver();
        try {
            try {
                myORB = ORB.getInstance("TransactionServer");
                myOA = OA.getRootOA(myORB);
                myORB.initORB(args, null);
                myOA.initOA();
                ORBManager.setORB(myORB);
                ORBManager.setPOA(myOA);
            }
            catch (Exception e) {
                System.err.println("Initialisation of TransactionServer failed: " + String.valueOf(e));
                throw e;
            }
            theOTS = new TransactionFactoryImple(objectName);
            try {
                TransactionServer.registerTransactionManager(resolver, myORB, theOTS.getReference());
                if (!printReady) {
                    System.out.println("Transaction manager registered.");
                }
            }
            catch (Exception e1) {
                System.err.println("Failed to bind transaction manager: " + String.valueOf(e1));
                if (exitOnComplete) {
                    throw new Exception("Failed to bind transaction manager:" + String.valueOf(e1));
                }
                System.exit(0);
            }
            if (printReady) {
                System.out.println("Ready");
            } else {
                System.out.println("JBossTS OTS Server startup.");
            }
            if (!exitOnComplete) {
                if (resolver == 5) {
                    myOA.run("TransactionManagerService");
                } else {
                    myOA.run();
                }
            }
        }
        catch (Exception e2) {
            System.err.println("TransactionServer caught exception " + String.valueOf(e2));
        }
        System.out.println("JBossTS OTS Server shutdown");
        theOTS = null;
        if (myOA != null) {
            myOA.destroy();
        }
        if (myORB != null) {
            myORB.shutdown();
        }
    }
}

