/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.recovery.transactions;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.jts.recovery.transactions.RecoveringTransaction;
import com.arjuna.ats.internal.jts.recovery.transactions.TransactionCacheItem;
import com.arjuna.ats.jts.common.jtsPropertyManager;
import com.arjuna.ats.jts.logging.jtsLogger;
import java.util.Hashtable;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;

public class TransactionCache {
    private static final Hashtable _theCache = new Hashtable();
    private static final int attemptsBeforeConversion = jtsPropertyManager.getJTSEnvironmentBean().getCommitedTransactionRetryLimit();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Status get_status(Uid actionUid, String theType) throws SystemException {
        Status theStatus = Status.StatusUnknown;
        TransactionCacheItem cacheItem = TransactionCache.get(actionUid, theType);
        if (cacheItem != null) {
            TransactionCacheItem transactionCacheItem = cacheItem;
            synchronized (transactionCacheItem) {
                RecoveringTransaction theTransaction = cacheItem.freshTransaction();
                if (theTransaction != null) {
                    theStatus = theTransaction.get_status();
                    cacheItem.setStatus(theStatus);
                }
            }
        }
        return theStatus;
    }

    public static Status getCachedStatus(Uid actionUid) throws SystemException {
        TransactionCacheItem cacheItem = TransactionCache.getKnown(actionUid);
        if (cacheItem != null) {
            return cacheItem.getStatus();
        }
        return Status.StatusNoTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Status getOriginalStatus(Uid actionUid, String theType) throws SystemException {
        Status theStatus = Status.StatusUnknown;
        TransactionCacheItem cacheItem = TransactionCache.get(actionUid, theType);
        if (cacheItem != null) {
            TransactionCacheItem transactionCacheItem = cacheItem;
            synchronized (transactionCacheItem) {
                RecoveringTransaction theTransaction = cacheItem.freshTransaction();
                if (theTransaction != null) {
                    if (jtsLogger.logger.isDebugEnabled()) {
                        jtsLogger.logger.debug((Object)"asking the tran for original status");
                    }
                    theStatus = theTransaction.getOriginalStatus();
                } else if (jtsLogger.logger.isDebugEnabled()) {
                    jtsLogger.logger.debug((Object)"no transaction in cache so not asking for original status");
                }
            }
        }
        return theStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRecoveryStatus(Uid actionUid, String theType) {
        int theRecoveryStatus = 0;
        TransactionCacheItem cacheItem = TransactionCache.get(actionUid, theType);
        if (cacheItem != null) {
            TransactionCacheItem transactionCacheItem = cacheItem;
            synchronized (transactionCacheItem) {
                RecoveringTransaction theTransaction = cacheItem.transaction();
                if (theTransaction != null) {
                    theRecoveryStatus = theTransaction.getRecoveryStatus();
                }
            }
        }
        return theRecoveryStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addResourceRecord(Uid actionUid, String theType, Uid rcUid, Resource r) {
        TransactionCacheItem cacheItem = TransactionCache.get(actionUid, theType);
        if (cacheItem != null) {
            TransactionCacheItem transactionCacheItem = cacheItem;
            synchronized (transactionCacheItem) {
                RecoveringTransaction theTransaction = cacheItem.freshTransaction();
                if (theTransaction != null) {
                    if (theTransaction.getRecoveryStatus() != 2) {
                        theTransaction.addResourceRecord(rcUid, r);
                    }
                    cacheItem.resetAttemptCount();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReplayPhaseReturnStatus replayPhase2(Uid actionUid, String theType) {
        ReplayPhaseReturnStatus returnStatus = ReplayPhaseReturnStatus.STANDARD_PROCESSING;
        TransactionCacheItem cacheItem = TransactionCache.get(actionUid, theType);
        if (cacheItem != null) {
            TransactionCacheItem transactionCacheItem = cacheItem;
            synchronized (transactionCacheItem) {
                boolean fullyCompleted = false;
                RecoveringTransaction theTransaction = cacheItem.freshTransaction();
                if (theTransaction != null && theTransaction.getRecoveryStatus() != 2) {
                    int previousAttempts;
                    boolean converting = false;
                    if (cacheItem.getStatus() == Status.StatusCommitted && (previousAttempts = cacheItem.countAttempts()) >= attemptsBeforeConversion && (converting = theTransaction.assumeComplete()) && jtsLogger.logger.isDebugEnabled()) {
                        jtsLogger.logger.debug((Object)(" Transaction " + String.valueOf(actionUid) + " assumed complete - changing type."));
                    }
                    theTransaction.replayPhase2();
                    cacheItem.setStatus(theTransaction.get_status());
                    fullyCompleted = theTransaction.allCompleted();
                    if (converting && !fullyCompleted) {
                        jtsLogger.i18NLogger.info_recovery_transactions_TransactionCache_4(actionUid);
                        theTransaction.removeOldStoreEntry();
                        cacheItem.updateType();
                        returnStatus = ReplayPhaseReturnStatus.ASSUME_COMPLETED;
                    }
                }
                if (fullyCompleted) {
                    jtsLogger.i18NLogger.info_recovery_transactions_TransactionCache_5(actionUid);
                    TransactionCache.remove(actionUid);
                } else {
                    cacheItem.clearTransaction();
                }
            }
        }
        return returnStatus;
    }

    private static synchronized TransactionCacheItem getKnown(Uid theUid) {
        TransactionCacheItem cacheItem = (TransactionCacheItem)_theCache.get(theUid);
        return cacheItem;
    }

    private static synchronized TransactionCacheItem get(Uid theUid, String theType) {
        TransactionCacheItem cacheItem = (TransactionCacheItem)_theCache.get(theUid);
        if (cacheItem == null) {
            cacheItem = new TransactionCacheItem(theUid, theType);
            _theCache.put(theUid, cacheItem);
        }
        return cacheItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void remove(Uid theUid) {
        TransactionCacheItem cacheItem = (TransactionCacheItem)_theCache.get(theUid);
        if (cacheItem == null) {
            if (jtsLogger.logger.isDebugEnabled()) {
                jtsLogger.logger.debug((Object)("TransactionCache.remove " + String.valueOf(theUid) + ": transaction not in cache"));
            }
        } else {
            TransactionCacheItem transactionCacheItem = cacheItem;
            synchronized (transactionCacheItem) {
                _theCache.remove(theUid);
            }
            if (jtsLogger.logger.isDebugEnabled()) {
                jtsLogger.logger.debug((Object)("TransactionCache.remove " + String.valueOf(theUid) + ": removed transaction from cache"));
            }
        }
    }

    public static enum ReplayPhaseReturnStatus {
        STANDARD_PROCESSING,
        ASSUME_COMPLETED;

    }
}

