/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class MultiOnCancellationCall<T>
extends AbstractMultiOperator<T, T> {
    private final Supplier<Uni<?>> supplier;

    public MultiOnCancellationCall(Multi<? extends T> upstream, Supplier<Uni<?>> supplier) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.supplier = ParameterValidation.nonNull(supplier, "supplier");
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> downstream) {
        this.upstream.subscribe().withSubscriber(new MultiOnCancellationCallProcessor(downstream));
    }

    class MultiOnCancellationCallProcessor
    extends MultiOperatorProcessor<T, T> {
        private final AtomicBoolean supplierInvoked;

        public MultiOnCancellationCallProcessor(MultiSubscriber<? super T> downstream) {
            super(downstream);
            this.supplierInvoked = new AtomicBoolean();
        }

        @Override
        public void onCompletion() {
            this.supplierInvoked.set(true);
            super.onCompletion();
        }

        @Override
        public void cancel() {
            this.execute().subscribe().with(ignoredItem -> super.cancel(), ignoredFailure -> super.cancel());
        }

        private Uni<?> execute() {
            if (this.supplierInvoked.compareAndSet(false, true)) {
                try {
                    return ParameterValidation.nonNull(MultiOnCancellationCall.this.supplier.get(), "uni");
                }
                catch (Throwable err) {
                    return Uni.createFrom().failure(err);
                }
            }
            return Uni.createFrom().nullItem();
        }
    }
}

