/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.extension;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ParsedBootOp;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller._private.OperationFailedRuntimeException;
import org.jboss.as.controller.extension.ExtensionAddHandler;
import org.jboss.as.controller.extension.MutableRootResourceRegistrationProvider;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;

public class ParallelExtensionAddHandler
implements OperationStepHandler {
    private final ExecutorService executor;
    private final List<ParsedBootOp> extensionAdds = new ArrayList<ParsedBootOp>();
    private ParsedBootOp ourOp;
    private final MutableRootResourceRegistrationProvider rootResourceRegistrationProvider;

    public ParallelExtensionAddHandler(ExecutorService executorService, MutableRootResourceRegistrationProvider rootResourceRegistrationProvider) {
        this.executor = executorService;
        this.rootResourceRegistrationProvider = rootResourceRegistrationProvider;
    }

    public void addParsedOp(ParsedBootOp op, ExtensionAddHandler handler) {
        ParsedBootOp toAdd = new ParsedBootOp(op, (OperationStepHandler)handler);
        this.extensionAdds.add(toAdd);
        this.getParsedBootOp().addChildOperation(toAdd);
    }

    public ParsedBootOp getParsedBootOp() {
        if (this.ourOp == null) {
            ModelNode op = Util.getEmptyOperation("parallel-extension-add", new ModelNode().setEmptyList());
            this.ourOp = new ParsedBootOp(op, (OperationStepHandler)this);
        }
        return this.ourOp;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(this.getParallelExtensionInitializeStep(), OperationContext.Stage.MODEL, true);
        for (int i = this.extensionAdds.size() - 1; i >= 0; --i) {
            ParsedBootOp op = this.extensionAdds.get(i);
            context.addStep(op.response, op.operation, op.handler, OperationContext.Stage.MODEL, true);
        }
    }

    private OperationStepHandler getParallelExtensionInitializeStep() {
        return new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                long start = System.currentTimeMillis();
                LinkedHashMap<String, Future<OperationFailedRuntimeException>> futures = new LinkedHashMap<String, Future<OperationFailedRuntimeException>>();
                ManagementResourceRegistration rootResourceRegistration = ParallelExtensionAddHandler.this.rootResourceRegistrationProvider.getRootResourceRegistrationForUpdate(context);
                for (ParsedBootOp parsedBootOp : ParallelExtensionAddHandler.this.extensionAdds) {
                    String module = parsedBootOp.address.getLastElement().getValue();
                    ExtensionAddHandler addHandler = (ExtensionAddHandler)ExtensionAddHandler.class.cast(parsedBootOp.handler);
                    Future<OperationFailedRuntimeException> future = ParallelExtensionAddHandler.this.executor.submit(new ExtensionInitializeTask(module, addHandler, rootResourceRegistration, parsedBootOp.getAddress()));
                    futures.put(module, future);
                }
                for (Map.Entry entry : futures.entrySet()) {
                    try {
                        OperationFailedRuntimeException ofe = (OperationFailedRuntimeException)((Future)entry.getValue()).get();
                        if (ofe == null) continue;
                        throw ofe;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw ControllerLogger.ROOT_LOGGER.moduleInitializationInterrupted((String)entry.getKey());
                    }
                    catch (ExecutionException e) {
                        throw ControllerLogger.ROOT_LOGGER.failedInitializingModule(e, (String)entry.getKey());
                    }
                }
                if (ControllerLogger.MGMT_OP_LOGGER.isDebugEnabled()) {
                    long elapsed = System.currentTimeMillis() - start;
                    ControllerLogger.MGMT_OP_LOGGER.debugf("Initialized extensions in [%d] ms", elapsed);
                }
            }
        };
    }

    private static class ExtensionInitializeTask
    implements Callable<OperationFailedRuntimeException> {
        private final String module;
        private final ExtensionAddHandler addHandler;
        private final ManagementResourceRegistration rootResourceRegistration;
        private final PathAddress address;

        public ExtensionInitializeTask(String module, ExtensionAddHandler addHandler, ManagementResourceRegistration rootResourceRegistration, PathAddress address) {
            this.module = module;
            this.addHandler = addHandler;
            this.rootResourceRegistration = rootResourceRegistration;
            this.address = address;
        }

        @Override
        public OperationFailedRuntimeException call() {
            OperationFailedRuntimeException failure = null;
            try {
                this.addHandler.initializeExtension(this.module, this.rootResourceRegistration, this.address);
            }
            catch (OperationFailedRuntimeException e) {
                failure = e;
            }
            return failure;
        }
    }
}

