/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.aesh.command.CommandException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.accesscontrol.AccessRequirement;
import org.jboss.as.cli.accesscontrol.AccessRequirementBuilder;
import org.jboss.as.cli.accesscontrol.PerNodeOperationAccess;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.DeploymentHandler;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithListValue;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.CommaSeparatedCompleter;
import org.jboss.as.cli.impl.FileSystemPathArgument;
import org.jboss.as.cli.impl.aesh.cmd.deployment.DeployArchiveCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.DeployFileCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.DeployUrlCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.EnableAllCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.EnableCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.ListCommand;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.AccessRequirements;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.CommandWithPermissions;
import org.jboss.as.cli.impl.aesh.cmd.deployment.security.Permissions;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

@Deprecated
public class DeployHandler
extends DeploymentHandler {
    private final ArgumentWithoutValue force;
    private final ArgumentWithoutValue l;
    private final ArgumentWithoutValue path;
    private final ArgumentWithoutValue url;
    private final ArgumentWithoutValue name;
    private final ArgumentWithoutValue rtName;
    private final ArgumentWithListValue serverGroups;
    private final ArgumentWithoutValue allServerGroups;
    private final ArgumentWithoutValue disabled;
    private final ArgumentWithoutValue enabled;
    private final ArgumentWithoutValue unmanaged;
    private final ArgumentWithValue script;
    private AccessRequirement listPermission;
    private AccessRequirement fullReplacePermission;
    private AccessRequirement mainAddPermission;
    private AccessRequirement deployPermission;
    private PerNodeOperationAccess serverGroupAddPermission;
    private static final String ALL = "*";
    private static final String REPLACE_OPTION = "force";

    public DeployHandler(CommandContext ctx) {
        super(ctx, "deploy", true);
        DefaultOperationRequestAddress requiredAddress = new DefaultOperationRequestAddress();
        requiredAddress.toNodeType("deployment");
        this.addRequiredPath(requiredAddress);
        this.l = new ArgumentWithoutValue(this, "-l");
        this.l.setExclusive(true);
        this.l.setAccessRequirement(this.listPermission);
        AccessRequirement addOrReplacePermission = AccessRequirementBuilder.Factory.create(ctx).any().requirement(this.mainAddPermission).requirement(this.fullReplacePermission).build();
        FilenameTabCompleter pathCompleter = FilenameTabCompleter.newCompleter(ctx);
        this.path = new FileSystemPathArgument((CommandHandlerWithArguments)this, pathCompleter, 0, "--path");
        this.path.addCantAppearAfter(this.l);
        this.path.setAccessRequirement(addOrReplacePermission);
        this.url = new ArgumentWithValue(this, "--url");
        this.url.addCantAppearAfter(this.path);
        this.path.addCantAppearAfter(this.url);
        this.url.setAccessRequirement(addOrReplacePermission);
        this.force = new ArgumentWithoutValue((CommandHandlerWithArguments)this, "--force", "-f");
        this.force.addRequiredPreceding(this.path);
        this.force.setAccessRequirement(this.fullReplacePermission);
        this.name = new ArgumentWithValue((CommandHandlerWithArguments)this, new CommandLineCompleter(){

            @Override
            public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
                int nextCharIndex;
                ParsedCommandLine args = ctx.getParsedCommandLine();
                try {
                    if (DeployHandler.this.path.isPresent(args) || DeployHandler.this.url.isPresent(args)) {
                        return -1;
                    }
                }
                catch (CommandFormatException e) {
                    return -1;
                }
                for (nextCharIndex = 0; nextCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(nextCharIndex)); ++nextCharIndex) {
                }
                if (ctx.getModelControllerClient() != null) {
                    List<String> deployments = Util.getDeployments(ctx.getModelControllerClient());
                    if (deployments.isEmpty()) {
                        return -1;
                    }
                    String opBuffer = buffer.substring(nextCharIndex).trim();
                    if (opBuffer.isEmpty()) {
                        candidates.addAll(deployments);
                        candidates.add(DeployHandler.ALL);
                    } else if (DeployHandler.ALL.startsWith(opBuffer)) {
                        candidates.add("* ");
                    } else {
                        for (String name : deployments) {
                            if (!name.startsWith(opBuffer)) continue;
                            candidates.add(name);
                        }
                        Collections.sort(candidates);
                    }
                    return nextCharIndex;
                }
                return -1;
            }
        }, "--name");
        this.name.addCantAppearAfter(this.l);
        this.path.addCantAppearAfter(this.name);
        this.url.addCantAppearAfter(this.name);
        this.name.setAccessRequirement(this.deployPermission);
        this.rtName = new ArgumentWithValue(this, "--runtime-name");
        this.rtName.addRequiredPreceding(this.path);
        this.rtName.setAccessRequirement(addOrReplacePermission);
        this.allServerGroups = new ArgumentWithoutValue(this, "--all-server-groups"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.allServerGroups.addRequiredPreceding(this.path);
        this.allServerGroups.addRequiredPreceding(this.name);
        this.allServerGroups.addCantAppearAfter(this.force);
        this.force.addCantAppearAfter(this.allServerGroups);
        this.allServerGroups.setAccessRequirement(this.deployPermission);
        this.serverGroups = new ArgumentWithListValue(this, new CommaSeparatedCompleter(){

            @Override
            protected Collection<String> getAllCandidates(CommandContext ctx) {
                return DeployHandler.this.serverGroupAddPermission.getAllowedOn(ctx);
            }
        }, "--server-groups"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.serverGroups.addRequiredPreceding(this.path);
        this.serverGroups.addRequiredPreceding(this.name);
        this.serverGroups.addCantAppearAfter(this.force);
        this.force.addCantAppearAfter(this.serverGroups);
        this.serverGroups.setAccessRequirement(this.deployPermission);
        this.serverGroups.addCantAppearAfter(this.allServerGroups);
        this.allServerGroups.addCantAppearAfter(this.serverGroups);
        this.disabled = new ArgumentWithoutValue(this, "--disabled");
        this.disabled.addRequiredPreceding(this.path);
        this.disabled.addCantAppearAfter(this.serverGroups);
        this.disabled.addCantAppearAfter(this.allServerGroups);
        if (ctx.isDomainMode()) {
            this.disabled.addCantAppearAfter(this.force);
            this.force.addCantAppearAfter(this.disabled);
        }
        this.disabled.setAccessRequirement(this.mainAddPermission);
        this.enabled = new ArgumentWithoutValue(this, "--enabled");
        this.enabled.addRequiredPreceding(this.path);
        this.enabled.addCantAppearAfter(this.serverGroups);
        this.enabled.addCantAppearAfter(this.allServerGroups);
        if (ctx.isDomainMode()) {
            this.enabled.addCantAppearAfter(this.force);
            this.enabled.addCantAppearAfter(this.disabled);
            this.disabled.addCantAppearAfter(this.enabled);
            this.force.addCantAppearAfter(this.enabled);
        }
        this.enabled.setAccessRequirement(this.mainAddPermission);
        this.unmanaged = new ArgumentWithoutValue(this, "--unmanaged");
        this.unmanaged.addRequiredPreceding(this.path);
        this.unmanaged.setAccessRequirement(this.mainAddPermission);
        this.script = new ArgumentWithValue(this, "--script");
        this.script.addRequiredPreceding(this.path);
    }

    @Override
    protected AccessRequirement setupAccessRequirement(CommandContext ctx) {
        Permissions permissions = new Permissions(ctx);
        this.listPermission = permissions.getListPermission();
        this.fullReplacePermission = permissions.getFullReplacePermission();
        this.mainAddPermission = permissions.getMainAddPermission();
        this.serverGroupAddPermission = permissions.getServerGroupAddPermission();
        this.deployPermission = permissions.getDeployPermission();
        return AccessRequirements.deploymentAccess(permissions).apply(ctx);
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        boolean l = this.l.isPresent(args);
        if (!args.hasProperties() || l) {
            try {
                ListCommand.listDeployments(ctx, l);
            }
            catch (CommandException ex) {
                throw new CommandLineException(ex.getLocalizedMessage());
            }
            return;
        }
        boolean unmanaged = this.unmanaged.isPresent(args);
        String path = this.path.getValue(args);
        String name = this.name.getValue(args);
        String rtName = this.rtName.getValue(args);
        String url = this.url.getValue(args);
        boolean force = this.force.isPresent(args);
        boolean disabled = this.disabled.isPresent(args);
        boolean enabled = this.enabled.isPresent(args);
        String serverGroups = this.serverGroups.getValue(args);
        boolean allServerGroups = this.allServerGroups.isPresent(args);
        ModelNode headersNode = this.headers.toModelNode(ctx);
        if (headersNode != null && headersNode.getType() != ModelType.OBJECT) {
            throw new CommandFormatException("--headers option has wrong value '" + headersNode + "'");
        }
        if (path == null && url == null) {
            if (name == null) {
                throw new CommandLineException("Filesystem path, --url or --name is  required.");
            }
            if (name.equals(ALL)) {
                if (force || disabled) {
                    throw new CommandLineException("force and disabled can't be used when deploying all disabled deployments");
                }
                EnableAllCommand command = new EnableAllCommand(ctx);
                command.allServerGroups = allServerGroups;
                command.headers = headersNode;
                command.serverGroups = serverGroups;
                try {
                    command.execute(ctx);
                }
                catch (CommandException ex) {
                    throw new CommandLineException(ex.getLocalizedMessage());
                }
                return;
            }
            EnableCommand command = new EnableCommand(ctx);
            command.allServerGroups = allServerGroups;
            command.headers = headersNode;
            command.serverGroups = serverGroups;
            command.name = name;
            try {
                command.execute(ctx);
            }
            catch (CommandException ex) {
                throw new CommandLineException(ex.getLocalizedMessage());
            }
            return;
        }
        if (path != null) {
            CommandWithPermissions c;
            if (url != null) {
                throw new CommandLineException("Filesystem path and --url can't be used together.");
            }
            File f = new File(path);
            if (DeployArchiveCommand.isCliArchive(f)) {
                command = new DeployArchiveCommand(ctx);
                ((DeployArchiveCommand)command).file = f;
                ((DeployArchiveCommand)command).script = this.script.getValue(args);
                c = command;
            } else {
                command = new DeployFileCommand(ctx, REPLACE_OPTION);
                ((DeployFileCommand)command).allServerGroups = allServerGroups;
                ((DeployFileCommand)command).disabled = disabled;
                ((DeployFileCommand)command).enabled = enabled;
                ((DeployFileCommand)command).file = f;
                ((DeployFileCommand)command).replace = force;
                ((DeployFileCommand)command).headers = headersNode;
                ((DeployFileCommand)command).name = name;
                ((DeployFileCommand)command).runtimeName = rtName;
                ((DeployFileCommand)command).serverGroups = serverGroups;
                ((DeployFileCommand)command).unmanaged = unmanaged;
                c = command;
            }
            try {
                c.execute(ctx);
            }
            catch (CommandException ex) {
                throw new CommandLineException(ex.getLocalizedMessage());
            }
            return;
        }
        if (url != null) {
            if (path != null) {
                throw new CommandLineException("Filesystem path and --url can't be used together.");
            }
            DeployUrlCommand command = new DeployUrlCommand(ctx, REPLACE_OPTION);
            command.allServerGroups = allServerGroups;
            command.disabled = disabled;
            command.enabled = enabled;
            try {
                command.deploymentUrl = new URL(url);
            }
            catch (MalformedURLException ex) {
                throw new CommandLineException(ex);
            }
            command.replace = force;
            command.headers = headersNode;
            command.runtimeName = rtName;
            command.serverGroups = serverGroups;
            try {
                command.execute(ctx);
            }
            catch (CommandException ex) {
                throw new CommandLineException(ex.getLocalizedMessage());
            }
        }
    }

    @Override
    public ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        boolean l = this.l.isPresent(args);
        if (!args.hasProperties() || l) {
            throw new CommandFormatException("No Option");
        }
        boolean unmanaged = this.unmanaged.isPresent(args);
        String path = this.path.getValue(args);
        String name = this.name.getValue(args);
        String rtName = this.rtName.getValue(args);
        String url = this.url.getValue(args);
        boolean force = this.force.isPresent(args);
        boolean disabled = this.disabled.isPresent(args);
        boolean enabled = this.enabled.isPresent(args);
        String serverGroups = this.serverGroups.getValue(args);
        boolean allServerGroups = this.allServerGroups.isPresent(args);
        ModelNode headersNode = this.headers.toModelNode(ctx);
        if (headersNode != null && headersNode.getType() != ModelType.OBJECT) {
            throw new CommandFormatException("--headers option has wrong value '" + headersNode + "'");
        }
        if (path == null && url == null) {
            if (name == null) {
                throw new CommandFormatException("Filesystem path, --url or --name is  required.");
            }
            if (name.equals(ALL)) {
                if (force || disabled) {
                    throw new CommandFormatException("force and disabled can't be used when deploying all disabled deployments");
                }
                EnableAllCommand command = new EnableAllCommand(ctx);
                command.allServerGroups = allServerGroups;
                command.headers = headersNode;
                command.serverGroups = serverGroups;
                return command.buildRequest(ctx);
            }
            EnableCommand command = new EnableCommand(ctx);
            command.allServerGroups = allServerGroups;
            command.headers = headersNode;
            command.serverGroups = serverGroups;
            command.name = name;
            return command.buildRequest(ctx);
        }
        if (path != null) {
            CommandWithPermissions c;
            if (url != null) {
                throw new CommandFormatException("Filesystem path and --url can't be used together.");
            }
            File f = new File(path);
            if (DeployArchiveCommand.isCliArchive(f)) {
                DeployArchiveCommand command = new DeployArchiveCommand(ctx);
                command.file = f;
                command.script = this.script.getValue(args);
                c = command;
            } else {
                DeployFileCommand command = new DeployFileCommand(ctx, REPLACE_OPTION);
                command.allServerGroups = allServerGroups;
                command.disabled = disabled;
                command.enabled = enabled;
                command.file = f;
                command.replace = force;
                command.headers = headersNode;
                command.name = name;
                command.runtimeName = rtName;
                command.serverGroups = serverGroups;
                command.unmanaged = unmanaged;
                c = command;
            }
            return c.buildRequest(ctx);
        }
        if (url != null) {
            if (path != null) {
                throw new CommandFormatException("Filesystem path and --url can't be used together.");
            }
            DeployUrlCommand command = new DeployUrlCommand(ctx, REPLACE_OPTION);
            command.allServerGroups = allServerGroups;
            command.disabled = disabled;
            command.enabled = enabled;
            try {
                command.deploymentUrl = new URL(url);
            }
            catch (MalformedURLException ex) {
                throw new CommandFormatException(ex);
            }
            command.replace = force;
            command.headers = headersNode;
            command.runtimeName = rtName;
            command.serverGroups = serverGroups;
            return command.buildRequest(ctx);
        }
        throw new CommandFormatException("Invalid Options.");
    }
}

