/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.net.URL;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.gui.GuiMain;
import org.jboss.as.cli.gui.JConsoleCLIPlugin;

public class ConnectDialog
extends JInternalFrame {
    static final String DEFAULT_REMOTE = "remote+http://localhost:9990";
    static final String HINT_CONNECT = "<protocol>://<hostname>:<port> OR empty";
    static final String HINT_CONNECT_BUTTON = "Connect to server CLI";
    static final String TEXT_CONNECT = "Connect";
    static final String TEXT_USERNAME = "Username: ";
    static final String TEXT_PASSWORD = "Password: ";
    static boolean IS_WIN;
    static boolean IS_GTK;
    private JTextField tfUserName;
    private JTextField tfPassword;
    private JTextField tfURL;
    private Action actionConnect;
    private Color hintTextColor;
    private JLabel statusBar;
    private final JConsoleCLIPlugin plugin;
    private final JPanel targetDisplay;
    private final JDesktopPane display = new JDesktopPane();
    private boolean started = false;

    public ConnectDialog(JConsoleCLIPlugin jConsoleCLIPlugin, JPanel targetDisplay) {
        this.plugin = jConsoleCLIPlugin;
        this.targetDisplay = targetDisplay;
        this.display.add(this);
        this.setVisible(false);
        this.createHelpers();
        this.createActions();
        this.createContent();
        this.setSize(this.getPreferredSize());
    }

    public void start() {
        if (this.started) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                ConnectDialog.this.inner_start();
            }
        }, "CLI GUI Connect Dialog").start();
    }

    private void inner_start() {
        this.targetDisplay.setVisible(false);
        this.targetDisplay.add(this.display);
        this.setLocation((this.display.getWidth() - this.getWidth()) / 2, (this.display.getHeight() - this.getHeight()) / 2);
        this.tfURL.setText(DEFAULT_REMOTE);
        try {
            this.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.targetDisplay.setVisible(true);
        this.targetDisplay.revalidate();
        this.targetDisplay.repaint();
        this.setVisible(true);
        this.setLocation((this.display.getWidth() - this.getWidth()) / 2, (this.display.getHeight() - this.getHeight()) / 2);
        this.started = true;
    }

    public void stop() {
        this.targetDisplay.remove(this.display);
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    private void createHelpers() {
        this.hintTextColor = UIManager.getColor("Panel.background");
        this.setDefaultCloseOperation(1);
        this.setResizable(false);
    }

    private void createActions() {
        this.actionConnect = new AbstractAction(TEXT_CONNECT){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (!this.isEnabled() || !ConnectDialog.this.isVisible()) {
                    return;
                }
                String controller = null;
                String user = null;
                String password = null;
                if (ConnectDialog.this.tfURL.getText().length() > 0) {
                    controller = ConnectDialog.this.tfURL.getText();
                    if (ConnectDialog.this.tfUserName.getText().length() > 0) {
                        user = ConnectDialog.this.tfUserName.getText();
                        password = ConnectDialog.this.tfPassword.getText();
                    }
                }
                try {
                    CommandContext cmdCtx = user == null ? CommandContextFactory.getInstance().newCommandContext() : CommandContextFactory.getInstance().newCommandContext(null, user, password.toCharArray());
                    cmdCtx.connectController(controller);
                    ConnectDialog.this.plugin.init(cmdCtx);
                }
                catch (CliInitializationException e) {
                    ConnectDialog.this.statusBar.setText(e.getMessage());
                    e.printStackTrace();
                    return;
                }
                catch (NumberFormatException e) {
                    ConnectDialog.this.statusBar.setText(e.getMessage());
                    e.printStackTrace();
                    return;
                }
                catch (CommandLineException e) {
                    e.printStackTrace();
                    ConnectDialog.this.statusBar.setText(e.getMessage());
                    return;
                }
                ConnectDialog.this.setVisible(false);
                ConnectDialog.this.clearStatus();
            }
        };
    }

    private void createContent() {
        JComponent cp = (JComponent)this.getContentPane();
        JPanel urlPanel = new JPanel(new BorderLayout(0, 12));
        urlPanel.setBorder(new EmptyBorder(6, 12, 12, 12));
        JPanel bottomPanel = new JPanel(new BorderLayout());
        this.statusBar = new JLabel(" ", 0);
        Font normalLabelFont = this.statusBar.getFont();
        Font boldLabelFont = normalLabelFont.deriveFont(1);
        Font smallLabelFont = normalLabelFont.deriveFont(normalLabelFont.getSize2D() - 1.0f);
        URL iconURL = GuiMain.class.getResource("/icon/wildfly_logo.png");
        Image logo = Toolkit.getDefaultToolkit().getImage(iconURL);
        ImageIcon icon = new ImageIcon(logo);
        JLabel mastheadLabel = new JLabel(icon);
        cp.add((Component)mastheadLabel, "North");
        cp.add((Component)urlPanel, "Center");
        cp.add((Component)bottomPanel, "South");
        this.tfURL = new JTextField();
        this.tfURL.getDocument().addDocumentListener(new UrlDocumentListener(this.tfURL));
        this.tfURL.setPreferredSize(this.tfURL.getPreferredSize());
        JPanel tfPanel = new JPanel(new BorderLayout());
        urlPanel.add((Component)tfPanel, "Center");
        tfPanel.add((Component)this.tfURL, "North");
        JLabel remoteMessageLabel = new JLabel(HINT_CONNECT);
        remoteMessageLabel.setFont(smallLabelFont);
        remoteMessageLabel.setForeground(this.hintTextColor);
        tfPanel.add((Component)remoteMessageLabel, "Center");
        JPanel userPwdPanel = new JPanel(new FlowLayout(3, 0, 0));
        userPwdPanel.setBorder(new EmptyBorder(12, 0, 0, 0));
        int tfWidth = IS_WIN ? 12 : 8;
        this.tfUserName = new JTextField(tfWidth);
        Labeled lc = new Labeled(TEXT_USERNAME, boldLabelFont, this.tfUserName);
        userPwdPanel.add(lc);
        this.tfPassword = new JPasswordField(tfWidth);
        this.tfPassword.setPreferredSize(this.tfUserName.getPreferredSize());
        lc = new Labeled(TEXT_PASSWORD, boldLabelFont, this.tfPassword);
        lc.setBorder(new EmptyBorder(0, 12, 0, 0));
        lc.setFont(boldLabelFont);
        userPwdPanel.add(lc);
        tfPanel.add((Component)userPwdPanel, "South");
        JButton connectButton = new JButton(this.actionConnect);
        connectButton.setToolTipText(HINT_CONNECT_BUTTON);
        JPanel buttonPanel = new JPanel(new FlowLayout(4));
        buttonPanel.setBorder(new EmptyBorder(12, 12, 2, 12));
        buttonPanel.add(connectButton);
        bottomPanel.add((Component)buttonPanel, "North");
        bottomPanel.add((Component)this.statusBar, "South");
        this.pack();
    }

    private void clearStatus() {
        this.statusBar.setText(" ");
    }

    static {
        String lafName = UIManager.getLookAndFeel().getClass().getName();
        IS_GTK = lafName.equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
        IS_WIN = lafName.equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
    }

    private class UrlDocumentListener
    implements DocumentListener {
        private static final String RX_PROTOCOL = "[A-Za-z\\-]+://";
        private static final String RX_HOST = "[1-9A-Za-z\\.]+";
        private static final String RX_PORT = ":\\d+";
        private static final String REGEXP = "([1-9A-Za-z\\.]+)|([1-9A-Za-z\\.]+:\\d+)|([A-Za-z\\-]+://[1-9A-Za-z\\.]+)|([A-Za-z\\-]+://[1-9A-Za-z\\.]+:\\d+)";
        private final JTextField textField;

        public UrlDocumentListener(JTextField textField) {
            this.textField = textField;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.validateURL();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.validateURL();
        }

        private void validateURL() {
            String text = this.textField.getText();
            if (text == null || text.length() == 0) {
                ConnectDialog.this.clearStatus();
                return;
            }
            if (Pattern.matches(REGEXP, text)) {
                ConnectDialog.this.clearStatus();
            } else {
                ConnectDialog.this.statusBar.setText("Connection url is not correct.");
            }
        }
    }

    private class Labeled
    extends JPanel {
        private final Component comp;
        private final JLabel leftLabel;

        public Labeled(String label, Font font, Component toBeLabeled) {
            this.comp = toBeLabeled;
            this.leftLabel = new JLabel(label);
            if (font != null) {
                this.leftLabel.setFont(font);
            }
            super.setLayout(new BorderLayout(6, 6));
            super.add((Component)this.leftLabel, "West");
            super.add(this.comp, "Center");
        }
    }
}

