/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.user.elytron;

import java.net.URI;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.wildfly.clustering.cache.batch.Batch;
import org.wildfly.clustering.cache.batch.SuspendedBatch;
import org.wildfly.clustering.context.Context;
import org.wildfly.clustering.session.user.User;
import org.wildfly.clustering.session.user.UserSessions;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.cache.CachedIdentity;
import org.wildfly.security.http.util.sso.SingleSignOn;

public class DistributableSingleSignOn
implements SingleSignOn {
    private final User<CachedIdentity, AtomicReference<SecurityIdentity>, String, Map.Entry<String, URI>> user;
    private final SuspendedBatch suspendedBatch;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public DistributableSingleSignOn(User<CachedIdentity, AtomicReference<SecurityIdentity>, String, Map.Entry<String, URI>> sso, SuspendedBatch suspendedBatch) {
        this.user = sso;
        this.suspendedBatch = suspendedBatch;
    }

    public String getId() {
        return this.user.getId();
    }

    public String getMechanism() {
        return ((CachedIdentity)this.user.getPersistentContext()).getMechanismName();
    }

    public boolean isProgrammatic() {
        return ((CachedIdentity)this.user.getPersistentContext()).isProgrammatic();
    }

    public String getName() {
        return ((CachedIdentity)this.user.getPersistentContext()).getName();
    }

    public SecurityIdentity getIdentity() {
        return (SecurityIdentity)((AtomicReference)this.user.getTransientContext()).get();
    }

    public Map<String, Map.Entry<String, URI>> getParticipants() {
        UserSessions sessions = this.user.getSessions();
        HashMap<String, Map.Entry> participants = new HashMap<String, Map.Entry>();
        for (String deployment : sessions.getDeployments()) {
            participants.put(deployment, (Map.Entry)sessions.getSession((Object)deployment));
        }
        return Collections.unmodifiableMap(participants);
    }

    public void setIdentity(SecurityIdentity identity) {
        ((AtomicReference)this.user.getTransientContext()).set(identity);
    }

    public boolean addParticipant(String applicationId, String sessionId, URI participant) {
        try (Context context = this.suspendedBatch.resumeWithContext();){
            boolean bl = this.user.getSessions().addSession((Object)applicationId, new AbstractMap.SimpleImmutableEntry<String, URI>(sessionId, participant));
            return bl;
        }
    }

    public Map.Entry<String, URI> removeParticipant(String applicationId) {
        try (Context context = this.suspendedBatch.resumeWithContext();){
            Map.Entry entry = (Map.Entry)this.user.getSessions().removeSession((Object)applicationId);
            return entry;
        }
    }

    public void invalidate() {
        if (this.closed.compareAndSet(false, true)) {
            try (Batch batch = this.suspendedBatch.resume();){
                this.user.invalidate();
            }
        }
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            try (Batch batch = this.suspendedBatch.resume();){
                this.user.close();
            }
        }
    }
}

