/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.cache.infinispan.persistence.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.infinispan.persistence.jdbc.common.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.common.connectionfactory.ConnectionFactory;
import org.infinispan.persistence.spi.PersistenceException;
import org.wildfly.clustering.cache.infinispan.persistence.jdbc.DataSourceConnectionFactoryConfiguration;

public class DataSourceConnectionFactory
extends ConnectionFactory {
    private static final System.Logger LOGGER = System.getLogger(DataSourceConnectionFactory.class.getName());
    private volatile DataSource factory;

    public void start(ConnectionFactoryConfiguration configuration, ClassLoader classLoader) throws PersistenceException {
        this.factory = ((DataSourceConnectionFactoryConfiguration)configuration).getDataSource();
    }

    public void stop() {
        this.factory = null;
    }

    public Connection getConnection() throws PersistenceException {
        try {
            return this.factory.getConnection();
        }
        catch (SQLException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void releaseConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                LOGGER.log(System.Logger.Level.WARNING, e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }
}

