/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.core.management.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.version.Stability;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.Resource;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.SuffixMatchFilter;
import org.wildfly.extension.core.management.UnstableApiAnnotationResourceDefinition;
import org.wildfly.extension.core.management.deployment.UnstableApiAnnotationAttachments;
import org.wildfly.extension.core.management.logging.CoreManagementLogger;
import org.wildfly.unstable.api.annotation.classpath.index.RuntimeIndex;
import org.wildfly.unstable.api.annotation.classpath.runtime.bytecode.ClassInfoScanner;

public class ScanUnstableApiAnnotationsProcessor
implements DeploymentUnitProcessor {
    private final RuntimeIndex runtimeIndex;
    private final String EXTRA_TEST_OUTPUT_PROPERTY = "org.wildfly.test.unstable-api-annotation.extra-output";
    private static final String BASE_MODULE_NAME = "org.wildfly._internal.unstable-api-annotation-index";
    private static final String README_TXT = "README.txt";
    private final Stability stability;
    private final UnstableApiAnnotationResourceDefinition.UnstableApiAnnotationLevel level;
    private boolean extraTestOutput;

    public ScanUnstableApiAnnotationsProcessor(RunningMode runningMode, Stability stability, UnstableApiAnnotationResourceDefinition.UnstableApiAnnotationLevel level) {
        this.stability = stability;
        this.level = level;
        this.extraTestOutput = System.getProperties().containsKey("org.wildfly.test.unstable-api-annotation.extra-output");
        boolean enableScanning = true;
        if (runningMode == RunningMode.ADMIN_ONLY) {
            enableScanning = false;
        } else if (!stability.enables(UnstableApiAnnotationResourceDefinition.STABILITY)) {
            enableScanning = false;
        }
        RuntimeIndex runtimeIndex = null;
        if (enableScanning) {
            ModuleLoader moduleLoader = ((ModuleClassLoader)this.getClass().getClassLoader()).getModule().getModuleLoader();
            Module module = null;
            try {
                module = moduleLoader.loadModule(BASE_MODULE_NAME);
            }
            catch (ModuleLoadException moduleLoadException) {
                // empty catch block
            }
            if (module != null) {
                ArrayList<URL> urls = new ArrayList<URL>();
                try {
                    Iterator it = module.globResources("**/*");
                    while (it.hasNext()) {
                        Resource resource = (Resource)it.next();
                        URL url = resource.getURL();
                        if (url.getFile().equals(README_TXT)) continue;
                        urls.add(resource.getURL());
                    }
                }
                catch (ModuleLoadException e) {
                    throw new RuntimeException(e);
                }
                if (!urls.isEmpty()) {
                    try {
                        runtimeIndex = RuntimeIndex.load(urls);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        this.runtimeIndex = runtimeIndex;
    }

    public void deploy(DeploymentPhaseContext phaseContext) {
        if (this.runtimeIndex == null) {
            return;
        }
        DeploymentUnit du = phaseContext.getDeploymentUnit();
        DeploymentUnit top = DeploymentUtils.getTopDeploymentUnit((DeploymentUnit)du);
        ClassInfoScanner scanner = (ClassInfoScanner)top.getAttachment(UnstableApiAnnotationAttachments.UNSTABLE_API_ANNOTATION_SCANNER);
        if (scanner == null) {
            scanner = new ClassInfoScanner(this.runtimeIndex);
            top.putAttachment(UnstableApiAnnotationAttachments.UNSTABLE_API_ANNOTATION_SCANNER, (Object)scanner);
        }
        ProcessedClassCounter counter = new ProcessedClassCounter();
        ServerLogger.DEPLOYMENT_LOGGER.debug((Object)"Scanning deployment for unstable api annotations");
        List resourceRoots = DeploymentUtils.allResourceRoots((DeploymentUnit)du);
        for (ResourceRoot root : resourceRoots) {
            Boolean shouldIndexResource = (Boolean)root.getAttachment(Attachments.INDEX_RESOURCE_ROOT);
            if (shouldIndexResource != null && !shouldIndexResource.booleanValue() || root.getAttachment(UnstableApiAnnotationAttachments.UNSTABLE_API_ANNOTATIONS_SCANNED) != null) continue;
            VisitorAttributes visitorAttributes = new VisitorAttributes();
            visitorAttributes.setLeavesOnly(true);
            visitorAttributes.setRecurseFilter(f -> true);
            try {
                List classChildren = root.getRoot().getChildren((VirtualFileFilter)new SuffixMatchFilter(".class", visitorAttributes));
                for (VirtualFile file : classChildren) {
                    if (!file.isFile() || !file.getName().endsWith(".class")) continue;
                    InputStream in = file.openStream();
                    try {
                        scanner.scanClass(in);
                        counter.incrementClassesScannedCount();
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            root.putAttachment(UnstableApiAnnotationAttachments.UNSTABLE_API_ANNOTATIONS_SCANNED, (Object)true);
        }
        long time = System.currentTimeMillis() - counter.startTime;
        CoreManagementLogger.UNSUPPORTED_ANNOTATION_LOGGER.debugf("Unstable annotation api scan took %d ms to scan %d classes", time, counter.getClassesScannedCount());
        if (this.extraTestOutput) {
            CoreManagementLogger.UNSUPPORTED_ANNOTATION_LOGGER.testOutputNumberOfClassesScanned(counter.getClassesScannedCount());
        }
    }

    public static class ProcessedClassCounter {
        private final long startTime = System.currentTimeMillis();
        private volatile int classesScannedCount = 0;

        void incrementClassesScannedCount() {
            ++this.classesScannedCount;
        }

        public int getClassesScannedCount() {
            return this.classesScannedCount;
        }
    }
}

