/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.infinispan.client.hotrod.impl.InternalRemoteCache;
import org.infinispan.client.hotrod.impl.operations.AbstractCacheOperation;
import org.infinispan.client.hotrod.impl.operations.CacheUnmarshaller;
import org.infinispan.client.hotrod.impl.operations.QuerySerializer;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.query.RemoteQuery;
import org.infinispan.client.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;
import org.infinispan.protostream.EnumMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.query.remote.client.impl.BaseQueryResponse;
import org.infinispan.query.remote.client.impl.QueryRequest;

public final class QueryOperation<T>
extends AbstractCacheOperation<BaseQueryResponse<T>> {
    private final RemoteQuery<T> remoteQuery;
    private final QuerySerializer querySerializer;
    private final boolean withHitCount;

    public QueryOperation(InternalRemoteCache<?, ?> remoteCache, RemoteQuery<T> remoteQuery, boolean withHitCount) {
        super(remoteCache);
        this.remoteQuery = remoteQuery;
        this.querySerializer = QuerySerializer.findByMediaType(remoteCache.getDataFormat().getValueType());
        this.withHitCount = withHitCount;
    }

    @Override
    public void writeOperationRequest(Channel channel, ByteBuf buf, Codec codec) {
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setQueryString(this.remoteQuery.getQueryString());
        if (this.remoteQuery.getStartOffset() > 0L) {
            queryRequest.setStartOffset(Long.valueOf(this.remoteQuery.getStartOffset()));
        }
        if (this.remoteQuery.getMaxResults() >= 0) {
            queryRequest.setMaxResults(Integer.valueOf(this.remoteQuery.getMaxResults()));
        }
        if (this.withHitCount) {
            if (this.remoteQuery.hitCountAccuracy() != null) {
                queryRequest.hitCountAccuracy(this.remoteQuery.hitCountAccuracy());
            }
        } else {
            queryRequest.hitCountAccuracy(Integer.valueOf(1));
        }
        queryRequest.setNamedParameters(this.getNamedParameters());
        queryRequest.setLocal(this.remoteQuery.isLocal());
        byte[] requestBytes = this.querySerializer.serializeQueryRequest(this.remoteQuery, queryRequest);
        ByteBufUtil.writeArray(buf, requestBytes);
    }

    @Override
    public short requestOpCode() {
        return 31;
    }

    @Override
    public short responseOpCode() {
        return 32;
    }

    private List<QueryRequest.NamedParameter> getNamedParameters() {
        Map namedParameters = this.remoteQuery.getParameters();
        if (namedParameters == null || namedParameters.isEmpty()) {
            return null;
        }
        SerializationContext serCtx = this.remoteQuery.getSerializationContext();
        ArrayList<QueryRequest.NamedParameter> params = new ArrayList<QueryRequest.NamedParameter>(namedParameters.size());
        for (Map.Entry e : namedParameters.entrySet()) {
            Object value = e.getValue();
            if (serCtx != null) {
                if (value instanceof Enum) {
                    EnumMarshaller encoder = (EnumMarshaller)serCtx.getMarshaller(value.getClass());
                    value = encoder.encode((Enum)value);
                } else if (value instanceof Boolean) {
                    value = value.toString();
                } else if (value instanceof Date) {
                    value = ((Date)value).getTime();
                } else if (value instanceof Instant) {
                    value = ((Instant)value).toEpochMilli();
                }
            }
            params.add(new QueryRequest.NamedParameter((String)e.getKey(), value));
        }
        return params;
    }

    @Override
    public BaseQueryResponse<T> createResponse(ByteBuf buf, short status, HeaderDecoder decoder, Codec codec, CacheUnmarshaller unmarshaller) {
        byte[] responseBytes = ByteBufUtil.readArray(buf);
        return this.querySerializer.readQueryResponse(this.internalRemoteCache.getRemoteCacheManager().getMarshaller(), this.remoteQuery, responseBytes);
    }
}

