/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.session.cache.metadata.fine;

import java.time.Duration;
import java.util.Map;
import org.wildfly.clustering.session.cache.metadata.fine.SessionAccessMetaDataEntry;
import org.wildfly.clustering.session.cache.metadata.fine.SessionAccessMetaDataEntryOffsets;

public class DefaultSessionAccessMetaDataEntry
implements SessionAccessMetaDataEntry {
    private volatile Map.Entry<Duration, Duration> lastAccess = Map.entry(Duration.ZERO, Duration.ZERO);

    @Override
    public boolean isNew() {
        return this.getLastAccessDuration().isZero();
    }

    @Override
    public Duration getSinceCreationDuration() {
        return this.lastAccess.getKey();
    }

    @Override
    public Duration getLastAccessDuration() {
        return this.lastAccess.getValue();
    }

    @Override
    public void setLastAccessDuration(Duration sinceCreation, Duration lastAccess) {
        this.lastAccess = Map.entry(sinceCreation, lastAccess);
    }

    public SessionAccessMetaDataEntry remap(SessionAccessMetaDataEntryOffsets offsets) {
        DefaultSessionAccessMetaDataEntry result = new DefaultSessionAccessMetaDataEntry();
        Map.Entry<Duration, Duration> lastAccess = this.lastAccess;
        result.setLastAccessDuration((Duration)offsets.getSinceCreationOffset().apply((Object)lastAccess.getKey()), (Duration)offsets.getLastAccessOffset().apply((Object)lastAccess.getValue()));
        return result;
    }

    public String toString() {
        Map.Entry<Duration, Duration> lastAccess = this.lastAccess;
        return String.format("{ since-creation = %s, last-access = %s }", lastAccess.getKey(), lastAccess.getValue());
    }
}

